<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Benefit_controller extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Benefit_model',
        ));
    }

    public function benefit_view()
    {
        $this->permission->method('benefit','read')->redirect();
        $data['title']    = display('benefit');  ;
        $data['mang']     = $this->Benefit_model->benefit_view();
        $data['module']   = "benefit";
        $data['page']     = "benefit_view";
        echo Modules::run('template/layout', $data);
    }

    public function create_benefit()
    {
        $data['title'] = display('benefit');
        #-------------------------------#
        $this->form_validation->set_rules('benefit_name', display('benefit_name'), 'required|max_length[150]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'benefit_name' => $this->input->post('benefit_name', true),
            ];

            if ($this->Benefit_model->benefit_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("benefit/Benefit_controller/create_benefit");

        } else {
            $data['title'] = display('benefit');
            $data['module'] = "benefit";
            $data['mang']     = $this->Benefit_model->benefit_view();
            $data['page'] = "benefit_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function update_benefit_form($id = null)
    {
        $this->form_validation->set_rules('benefit_id',display('benefit_id'));
        $this->form_validation->set_rules('benefit_name',display('benefit_name'),'required|max_length[150]');

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $Data = [
                'benefit_id'         =>   $this->input->post('benefit_id',true),
                'benefit_name' => $this->input->post('benefit_name',true),

            ];

            if ($this->Benefit_model->update_benefit($Data)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("benefit/Benefit_controller/benefit_view");



        } else {
            $data['title']      = display('update');
            $data['data']      =$this->Benefit_model->benefit_updateForm($id);
            $data['module']    = "benefit";
            $data['page']      = "update_benefit_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function delete_benefit($id=null){
        $this->permission->module('benefit','delete')->redirect();
        if($this->Benefit_model->benefit_delete($id)) {
            #set success message
            $this->session->set_flashdata('message',display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception',display('please_try_again'));
        }
        redirect('benefit/Benefit_controller/benefit_view');
    }

}
