<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Certificate_controller extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Certificate_model'
        ));
        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function certificate_view()
    {
        $this->permission->method('certificate', 'read')->redirect();

        $data['title'] = display('certificate');;
        $data['mang'] = $this->Certificate_model->certificate_view();
        $data['module'] = "certificate";
        $data['page'] = "certificate_view";
        echo Modules::run('template/layout', $data);
    }

    public function create_certificate()
    {
        $this->form_validation->set_rules('certificate_name', 'Certificate Name');
        $this->form_validation->set_rules('certificate_number', 'Certificate Number');
        $this->form_validation->set_rules('ct_description', 'Description');
        $this->form_validation->set_rules('start_date', "Start Date", 'max_length[50]');
        $this->form_validation->set_rules('end_date', "End Date", 'max_length[50]');
        $this->form_validation->set_rules('certificate_comments', "Comments", 'max_length[500]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[50]');


        #-------------------------------#
        if ($this->form_validation->run() === true) {


            $postData = [
                'certificate_name' => $this->input->post('certificate_name', true),
                'certificate_number' => $this->input->post('certificate_number', true),
                'ct_description' => $this->input->post('ct_description', true),
                'start_date' => $this->input->post('start_date', true),
                'end_date' => $this->input->post('end_date', true),
                'certificate_comments' => $this->input->post('certificate_comments', true),
                'employee_id' => $this->input->post('employee_id', true),

            ];

            if ($this->Certificate_model->certificate_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_created'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("certificate/Certificate_controller/create_certificate");


        } else {
            $data['title'] = display('certificate');
            $data['module'] = "certificate";
            $data['mang'] = $this->Certificate_model->certificate_view();
            $data['dropdown'] = $this->Certificate_model->dropdown();
            $data['page'] = "certificate_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function update_certificate_form($id = null)
    {
        $data['title'] = display('certificate');
        #-------------------------------#
        $this->form_validation->set_rules('certificate_name', 'Certificate Name');
        $this->form_validation->set_rules('certificate_number', 'Certificate Number');
        $this->form_validation->set_rules('ct_description', 'Description');
        $this->form_validation->set_rules('start_date', "Start Date", 'max_length[50]');
        $this->form_validation->set_rules('end_date', "End Date", 'max_length[50]');
        $this->form_validation->set_rules('certificate_comments', "Comments", 'max_length[500]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[50]');

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $Data = [
                'certificate_id' => $this->input->post('certificate_id', true),
                'certificate_name' => $this->input->post('certificate_name', true),
                'certificate_number' => $this->input->post('certificate_number', true),
                'ct_description' => $this->input->post('ct_description', true),
                'start_date' => $this->input->post('start_date', true),
                'end_date' => $this->input->post('end_date', true),
                'certificate_comments' => $this->input->post('certificate_comments', true),
                'employee_id' => $this->input->post('employee_id', true),
            ];

            if ($this->Certificate_model->update_certificate($Data)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("certificate/Certificate_controller/certificate_view");


        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Certificate_model->certificate_updateForm($id);
            $data['dropdown'] = $this->Certificate_model->dropdown();
            $data['bb'] = $this->Certificate_model->get_id($id);
            $data['module'] = "certificate";
            $data['page'] = "update_certificate_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function delete_certificate($id = null)
    {
        $this->permission->method('certificate','delete')->redirect();

        if ($this->Certificate_model->certificate_delete($id)) {
            #set success message
            $this->session->set_flashdata('message',display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception',display('please_try_again'));

        }
        redirect("certificate/Certificate_controller/certificate_view");
    }

}
