<?php
$start_date = $row->emp_exp_start_date;
$end_date = $row->emp_exp_end_date;

$diff = abs(strtotime($end_date) - strtotime($start_date));
$years = floor($diff / (365*60*60*24));
$months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));

$total_experience = $years . " years " . " and " . $months . " months";

$probation_start_date = $row->probation_start_date;
$probation_end_date = $row->probation_end_date;

$prob_diff = abs(strtotime($probation_end_date) - strtotime($probation_start_date));
$prob_years = floor($prob_diff / (365*60*60*24));
$prob_months = floor(($prob_diff - $prob_years * 365*60*60*24) / (30*60*60*24));

$prob_duration = $prob_months . " months";
?>
<div class="row">
    <?php
    if ($row->terminate == 1){ ?>
        <div>
            <h3 style="color: red;">This employee has been terminated on <?php echo $row->terminate_date ?>.</h3>
            <p><b>Reason:</b> <?php echo $row->terminate_reason ?></p>
        </div>
    <?php }
    ?>
    <div class="col-sm-12 col-md-4 employee-cv">

        <div class="card-header resume">

            <div><img src="<?php if ($row->picture) {
                    echo base_url() . $row->picture;
                } else {
                    echo base_url() . 'assets/img/user/default.jpg';
                } ?>" width=100px; height=100px; class="img-circle"/></div>

        </div>
        <div class="card-content">
            <div class="card-content-member">
                <h4 class="m-t-0"><?php echo $row->first_name . "  " . $row->last_name; ?><span
                            class="preformancerating"> <span class="<?php if ($perform > 0 && $perform < 1) {
                            echo 'fa fa-star-half';
                        } else if ($perform >= 1) {
                            echo 'fa fa-star';
                        } else {
                            echo 'fa fa-star-o';
                        } ?>"></span>
                    <span class="<?php if ($perform > 1 && $perform < 2) {
                        echo 'fa fa-star-half';
                    } else if ($perform >= 2) {
                        echo 'fa fa-star';
                    } else {
                        echo 'fa fa-star-o';
                    } ?>"></span>
                    <span class="<?php if ($perform > 2 && $perform < 3) {
                        echo 'fa fa-star-half';
                    } else if ($perform >= 3) {
                        echo 'fa fa-star';
                    } else {
                        echo 'fa fa-star-o';
                    } ?>"></span>
                    <span class="<?php if ($perform > 3 && $perform < 4) {
                        echo 'fa fa-star-half';
                    } else if ($perform >= 4) {
                        echo 'fa fa-star';
                    } else {
                        echo 'fa fa-star-o';
                    } ?>"></span>
                    <span class="<?php if ($perform > 4 && $perform < 5) {
                        echo 'fa fa-star-half';
                    } else if ($perform == 5) {
                        echo 'fa fa-star';
                    } else {
                        echo 'fa fa-star-o';
                    } ?>"></span>

                </span></h4>
                <h5>
                    Department: <?php $dept = $this->db->select('department_name')->from('department')->where('dept_id', $row->parent_id)->get()->row();
                    echo $dept->department_name;
                    ?></h5>
                <p class="m-0"><i class="fa fa-mobile" aria-hidden="true"></i>
                    <?php echo $row->phone; ?></p>
            </div>
            <div class="card-content-languages">
                <div class="card-content-languages-group"></div>
                <div class="card-content-languages-group">
                    <table class="table table-hover" width="100%">
                        <caption class="resumecaption"><?php echo display('personal_information') ?></caption>
                        <tr>
                            <th><?php echo display('name') ?></th>
                            <td><?php echo $row->first_name . " " . $row->last_name; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo display('phone') ?></th>
                            <td><?php echo $row->phone; ?></td>
                        </tr>
                        <tr>
                            <th>Employee Code</th>
                            <td><?php echo $row->emp_code; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo display('email') ?></th>
                            <td><?php echo $row->email; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo display('state') ?></th>
                            <td><?php echo $row->state; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo display('city') ?></th>
                            <td><?php echo $row->city; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo display('zip') ?></th>
                            <td><?php echo $row->zip; ?></td>
                        </tr>
                        <tr>
                            <th>CNIC</th>
                            <td><?php echo $row->emp_cnic; ?></td>
                        </tr>
                        <tr>
                            <th>Experience</th>
                            <td><?php echo $total_experience ?></td>
                        </tr>
                    </table>

                </div>
                <div class="card-content-languages-group">
                    <table class="table table-hover" width="100%">
                        <caption class="resumecaption"><?php echo display('biographicalinfo') ?></caption>
                        <tr>
                            <th><?php echo display('dob') ?></th>
                            <td><?php echo $row->dob; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo display('gender') ?></th>
                            <td><?php if ($row->gender == 1) {
                                    echo 'Male';
                                } else if ($row->gender == 2) {
                                    echo 'Female';
                                } else {
                                    echo 'Other';
                                }
                                ?></td>
                        </tr>
                        <tr>
                            <th><?php echo display('marital_status') ?></th>
                            <td><?php
                                if ($row->marital_status == 1) {
                                    echo 'Single';
                                } else if ($row->marital_status == 2) {
                                    echo 'Married';
                                } else if ($row->marital_status == 3) {
                                    echo 'Divorced';
                                } else if ($row->marital_status == 4) {
                                    echo 'Widowed';
                                } else {
                                    echo 'Other';
                                }; ?></td>
                        </tr>
                        <tr>

                            <th><?php echo display('ethnic_group') ?> </th>
                            <td><?php echo $row->ethnic_group; ?></td>
                        </tr>
                        <tr>

                            <th><?php echo display('eeo_class_gp') ?></th>
                            <td><?php echo $row->eeo_class_gp; ?></td>
                        </tr>
                        <tr>

                            <th><?php echo display('ssn') ?></th>
                            <td><?php echo $row->ssn; ?></td>
                        </tr>
                        <tr>

                            <th><?php echo display('work_in_state') ?></th>
                            <td><?php if ($row->work_in_state == 1) {
                                    echo 'Yes';
                                } else {
                                    echo 'No';
                                } ?></td>
                        </tr>
                        <tr>

                            <th><?php echo display('live_in_state') ?></th>
                            <td><?php if ($row->live_in_state == 1) {
                                    echo 'Yes';
                                } else {
                                    echo 'No';
                                } ?></td>
                        </tr>
                    </table>

                </div>
                <div class="card-content-languages-group">

                    <table class="table table-hover" width="100%">
                        <caption class="resumecaption"><?php echo "Positional Log" ?></caption>
                        <thead>
                        <tr>
                            <th><?php echo "Previous Salary" ?></th>
                            <th><?php echo "Previous Position" ?></th>
                            <th><?php echo "Date" ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $sl = 1; ?>
                        <?php
                        foreach ($salarylog as $log){ ?>
                            <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                <td><?php echo $log->old_salary ?></td>
                                <td><?php echo $log->old_designation ?></td>
                                <td><?php echo $log->change_date ?></td>
                            </tr>
                        <?php }
                        ?>

                        <?php $sl++; ?>
                        </tbody>
                    </table>

                </div>
                <div class="card-content-languages-group">

                    <table class="table table-hover" width="100%">
                        <caption class="resumecaption"><?php echo "Current Position" ?></caption>
                        <tr>
                            <th><?php echo "Current Salary" ?></th>
                            <td><?php echo $row->rate; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo "Current Position" ?></th>
                            <td><?php echo $row->position_name; ?></td>
                        </tr>
                    </table>

                </div>
            </div>
            <div class="card-footer">
                <div class="card-footer-stats">
                    <div>
                        <p></p><span class="stats-small"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-12 col-md-8 employee-cv-info">
        <div class="row">
            <div class="col-sm-12 col-md-12 rating-block">

                <table class="table table-hover" width="100%">


                    <caption class="resumecaption"><?php echo display('positional_information') ?></caption>
                    <tr>
                        <th><?php echo display('division') ?></th>
                        <td><?php echo $row->department_name; ?></td>
                    </tr>
                    <tr>
                        <th><?php echo display('designation') ?></th>
                        <td><?php echo $row->position_name; ?></td>
                    </tr>
                    <tr>
                        <th><?php echo display('duty_type') ?></th>
                        <td><?php
                            if ($row->duty_type == 1) {
                                echo 'Full Time';
                            } else if ($row->duty_type == 2) {
                                echo 'Part Time';
                            } else if ($row->duty_type == 3) {
                                echo 'Contructual';
                            } else {
                                echo 'Other';
                            } ?></td>
                    </tr>

                    <tr>
                        <th><?php echo display('hire_date') ?></th>
                        <td><?php echo $row->hire_date; ?></td>
                    </tr>
                    <tr>
                        <th><?php echo display('original_hire_date') ?></th>
                        <td><?php echo $row->original_hire_date; ?></td>
                    </tr>
                    <tr>
                        <th><?php echo display('rate_type') ?></th>
                        <td><?php if ($row->rate_type == 1) {
                                echo 'Hourly';
                            } else {
                                echo 'Salary';
                            } ?></td>
                    </tr>
                    <tr>
                        <th><?php echo display('s_rate') ?></th>
                        <td><?php echo $row->rate; ?></td>
                    </tr>
                    <tr>
                        <th><?php echo display('pay_frequency') ?></th>
                        <td><?php
                            if ($row->pay_frequency == 1) {
                                echo 'Weekly';
                            } else if ($row->pay_frequency == 2) {
                                echo 'Biweekly';
                            } else if ($row->pay_frequency == 4) {
                                echo 'Monthly';
                            } else {
                                echo 'Annual';
                            } ?></td>
                    </tr>
                    <tr>
                        <th><?php echo display('home_department') ?></th>
                        <td><?php echo $row->home_department; ?></td>
                    </tr>


                    <tr>
                        <th><?php echo display('super_visor_name') ?></th>
                        <td><?php
                            $supervisor = $this->db->select('first_name,last_name')->from('employee_history')->where('employee_id', $row->super_visor_id)->get()->row();
                            echo(!empty($supervisor) ? $supervisor->first_name . ' ' . $supervisor->last_name : 'Self');
                            ?></td>
                    </tr>
                    <tr>
                        <th><?php echo display('is_super_visor') ?></th>
                        <td><?php
                            if ($row->is_super_visor == 1) {
                                echo 'Yes';
                            } else {
                                echo 'No';
                            }
                            ?></td>
                    </tr>
                    <tr>
                        <th><?php echo "Probation Start Date" ?></th>
                        <td><?php echo date("d M Y", strtotime($row->probation_start_date)); ?></td>
                    </tr>
                    <tr>
                        <th><?php echo "Probation End Date" ?></th>
                        <td><?php echo date("d M Y", strtotime($row->probation_end_date)); ?></td>
                    </tr>
                    <tr>
                        <th><?php echo "Duration" ?></th>
                        <td><?php echo $prob_duration ?></td>
                    </tr>
                    <tr>
                        <th><?php echo "Probation Status" ?></th>
                        <td><?php
                            if ($row->probation_status == 1){
                                echo "Extended";
                            }elseif ($row->probation_status == 2){
                                echo "Successfully Completed";
                            }
                            ?></td>
                    </tr>
                </table>

            </div>

            <div class="col-sm-12 col-md-12 rating-block">

                <table class="table table-hover" width="100%">


                    <caption class="resumecaption"><?php echo display('benifits') ?></caption>
                    <?php foreach ($benifit as $benif) { ?>
                        <tr>
                            <th><?php echo display('benifit_class_code') ?></th>
                            <td><?php echo $benif->bnf_cl_code; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo display('benifit_desc') ?></th>
                            <td><?php echo $benif->bnf_cl_code_des; ?></td>
                        </tr>

                        <tr>
                            <th><?php echo display('benifit_acc_date') ?></th>
                            <td><?php echo $benif->bnff_acural_date; ?></td>
                        </tr>
                    <?php } ?>

                </table>

            </div>
            <div class="col-sm-12 col-md-12 rating-block">

                <table class="table table-hover" width="100%">


                    <caption class="resumecaption">Emergency Contact</caption>
                    <tr>
                        <th><?php echo display('emerg_contct') ?></th>
                        <td><?php echo $row->emerg_contct; ?></td>
                    </tr>
                    <tr>
                        <th><?php echo display('emerg_home_phone') ?></th>
                        <td><?php echo $row->emrg_h_phone; ?></td>
                    </tr>

                    <tr>
                        <th><?php echo display('emrg_w_phone') ?></th>
                        <td><?php echo $row->emrg_w_phone; ?></td>
                    </tr>
                </table>

            </div>

            <h2>Qualification</h2>

            <div class="col-sm-12 col-md-12 rating-block">

                <table class="table table-hover" width="100%">


                    <caption class="resumecaption">Masters</caption>
                    <tr>
                        <th>Degree Title</th>
                        <td><?php echo $row->masters_degree_title ?></td>
                    </tr>
                    <tr>
                        <th>Majors</th>
                        <td><?php echo $row->masters_majors ?></td>
                    </tr>
                    <tr>
                        <th>Year Completion</th>
                        <td><?php echo $row->masters_year_completion ?></td>
                    </tr>
                    <tr>
                        <th>Institute</th>
                        <td><?php echo $row->masters_institute ?></td>
                    </tr>
                    <tr>
                        <th>Location</th>
                        <td><?php echo $row->masters_location ?></td>
                    </tr>
                    <tr>
                        <th>CPGA</th>
                        <td><?php echo $row->masters_cgpa ?></td>
                    </tr>

                </table>

            </div>

            <div class="col-sm-12 col-md-12 rating-block">

                <table class="table table-hover" width="100%">


                    <caption class="resumecaption">Bachelors</caption>
                    <tr>
                        <th>Degree Title</th>
                        <td><?php echo $row->bachelors_degree_title ?></td>
                    </tr>
                    <tr>
                        <th>Majors</th>
                        <td><?php echo $row->bachelors_majors ?></td>
                    </tr>
                    <tr>
                        <th>Year Completion</th>
                        <td><?php echo $row->bachelors_year_completion ?></td>
                    </tr>
                    <tr>
                        <th>Institute</th>
                        <td><?php echo $row->bachelors_institute ?></td>
                    </tr>
                    <tr>
                        <th>Location</th>
                        <td><?php echo $row->bachelors_location ?></td>
                    </tr>
                    <tr>
                        <th>CPGA</th>
                        <td><?php echo $row->bachelors_cgpa ?></td>
                    </tr>

                </table>

            </div>

            <div class="col-sm-12 col-md-12 rating-block">

                <table class="table table-hover" width="100%">


                    <caption class="resumecaption">Intermediate</caption>
                    <tr>
                        <th>Degree Title</th>
                        <td><?php echo $row->inter_degree_title ?></td>
                    </tr>
                    <tr>
                        <th>Majors</th>
                        <td><?php echo $row->inter_majors ?></td>
                    </tr>
                    <tr>
                        <th>Year Completion</th>
                        <td><?php echo $row->inter_year_completion ?></td>
                    </tr>
                    <tr>
                        <th>Institute</th>
                        <td><?php echo $row->inter_institute ?></td>
                    </tr>
                    <tr>
                        <th>Location</th>
                        <td><?php echo $row->inter_location ?></td>
                    </tr>
                    <tr>
                        <th>Percentage</th>
                        <td><?php echo $row->inter_percentage ?></td>
                    </tr>

                </table>

            </div>

            <div class="col-sm-12 col-md-12 rating-block">

                <table class="table table-hover" width="100%">


                    <caption class="resumecaption">Matriculation</caption>
                    <tr>
                        <th>Degree Title</th>
                        <td><?php echo $row->matric_degree_title ?></td>
                    </tr>
                    <tr>
                        <th>Majors</th>
                        <td><?php echo $row->matric_majors ?></td>
                    </tr>
                    <tr>
                        <th>Year Completion</th>
                        <td><?php echo $row->matric_year_completion ?></td>
                    </tr>
                    <tr>
                        <th>Institute</th>
                        <td><?php echo $row->matric_institute ?></td>
                    </tr>
                    <tr>
                        <th>Location</th>
                        <td><?php echo $row->matric_location ?></td>
                    </tr>
                    <tr>
                        <th>Percentage</th>
                        <td><?php echo $row->matric_percentage ?></td>
                    </tr>

                </table>

            </div>

            <div class="col-sm-12 col-md-12 rating-block">

                <table class="table table-hover" width="100%">


                    <caption class="resumecaption">Warnings</caption>

                    <table class="table table-hover" width="100%">
                        <thead>
                        <tr>
                            <th><?php echo "Sr. No" ?></th>
                            <th><?php echo "Reason" ?></th>
                            <th><?php echo "Date" ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $sl = 1; ?>
                        <?php $sr = 1; ?>
                        <?php
                        foreach ($warnings as $warning){ ?>
                            <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                <td><?php echo $sr ?></td>
                                <td><?php echo $warning->reason ?></td>
                                <td><?php echo $warning->date ?></td>
                            </tr>
                            <?php $sr++; ?>
                        <?php }
                        ?>

                        <?php $sl++; ?>
                        </tbody>
                    </table>

                </table>

            </div>

        </div>


    </div>
    <?php if (!empty($award)) { ?>
        <div class="row">
            <div class="col-sm-12 rating-block  employee-award">
                <table class="table table-border table-responsive">
                    <caption>Award</caption>
                    <thead>
                    <tr>
                        <th><?php echo display('award_name') ?></th>
                        <th><?php echo display('aw_description') ?></th>
                        <th><?php echo display('awr_gift_item') ?></th>
                        <th><?php echo display('date') ?></th>
                        <th><?php echo display('awarded_by') ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($award as $awrd) { ?>
                        <tr>
                            <td><?php echo $awrd->award_name; ?></td>
                            <td><?php echo $awrd->aw_description; ?></td>
                            <td><?php echo $awrd->awr_gift_item; ?></td>
                            <td><?php echo $awrd->date; ?></td>
                            <td><?php echo $awrd->awarded_by; ?></td>

                        </tr>
                    <?php } ?>
                    </tbody>
                </table>

            </div>
        </div>
    <?php } ?>

</div>