<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Overtime extends MX_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Overtime_model'
        ));

        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function create_overtime()
    {
        $data['title'] = "Overtime";

        /*----------FORM VALIDATION RULES----------*/
        $this->form_validation->set_rules('ovt_start_date', 'Start Date', 'required');
        $this->form_validation->set_rules('ovt_start_time', 'Start Time', 'required');
        $this->form_validation->set_rules('ovt_end_date', 'End Date', 'required');
        $this->form_validation->set_rules('ovt_end_time', 'End Time', 'required');
        $this->form_validation->set_rules('ovt_reason', 'End Date', 'required');

        $ovt_start_date = $this->input->post('ovt_start_date', true);
        $ovt_start_time = $this->input->post('ovt_start_time', true);

        $ovt_end_date = $this->input->post('ovt_end_date', true);
        $ovt_end_time = $this->input->post('ovt_end_time', true);

        $combine_ovt_start = date('Y-m-d H:i:s', strtotime("$ovt_start_date $ovt_start_time"));
        $combine_ovt_end = date('Y-m-d H:i:s', strtotime("$ovt_end_date $ovt_end_time"));

        $diff = abs(strtotime($combine_ovt_end) - strtotime($combine_ovt_start));
        $total_time = $diff / (60 * 60);

        $sup_id = $this->input->post('supervisor_id', true);
        $employee_id = $this->input->post('employee_id', true);

        $data['overtime'] = (object)$postData = array(
            'ovt_start_date' => $this->input->post('ovt_start_date', true),
            'ovt_start_time' => $this->input->post('ovt_start_time', true),
            'ovt_end_date' => $this->input->post('ovt_end_date', true),
            'ovt_end_time' => $this->input->post('ovt_end_time', true),
            'ovt_reason' => $this->input->post('ovt_reason', true),
            'employee_id' => $employee_id,
            'sup_id' => $sup_id,
            'total_time' => $total_time,
        );

        /*-----------CREATE A NEW RECORD-----------*/
        if ($this->form_validation->run() === true) {

            if ($this->Overtime_model->create_overtime($postData)) {
                $get_sup_email = $this->Overtime_model->get_sup_email($sup_id);
                $sup_email = $get_sup_email[0]->email;

                $get_emp_name = $this->Overtime_model->get_employee($employee_id);
                $employee_name = $get_emp_name[0]->first_name . " " . $get_emp_name[0]->last_name;

                $msg = "Hi! <br> You have received the new overtime request from <strong>$employee_name</strong>. <br> Please <a href='dynatunerspeople.com'>login</a> to view the request";
                $this->email->set_mailtype("html");
                $this->email->set_newline("\r\n");
                $this->email->set_crlf("\r\n");
                $this->email->from(FROM_EMAIL);
                $this->email->to($sup_email);
//                $this->email->CC('fey.ahmad@dynatuners.com');
                $this->email->subject("Overtime Request");
                $this->email->message($msg);
                $this->email->send();
                #set success message
                $this->session->set_flashdata('message', "Your overtime has been sent to your supervisor");
            } else {
                #set exception message
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('employee_overtime/Overtime/overtime_log');

        } else {

            $employee_id = $this->session->userdata('employee_id');
            $data['emp_details'] = $this->Overtime_model->get_employee_details($employee_id);
            $data['module'] = "employee_overtime";
            $data['page'] = "create_overtime";
            echo Modules::run('template/layout', $data);
        }

    }

    public function overtime_log()
    {
        $data['title'] = "Overtime Log";
        $employee_id = $this->session->userdata('employee_id');
        $data['ovt_details'] = $this->Overtime_model->get_overtime_details($employee_id);
        $data['module'] = "employee_overtime";
        $data['page'] = "overtime_log";
        echo Modules::run('template/layout', $data);
    }

    public function overtime_requests()
    {
        $data['title'] = "Overtime Requests";
        $supervisor_id = $this->session->userdata('employee_id');
        $data['ovt_requests'] = $this->Overtime_model->get_overtime_requests($supervisor_id);
        $data['admin_ovt_requests'] = $this->Overtime_model->get_admin_overtime_requests($supervisor_id);
        $data['module'] = "employee_overtime";
        $data['page'] = "overtime_requests";
        echo Modules::run('template/layout', $data);

    }

    public function overtime_approval()
    {
        $ovt_id = $_GET['ovt_id'];
        $approve_by_sup = $_GET['approve_by_sup'];
        $employee_id = $_GET['emp_id'];

        $postData = [
            'ovt_id' => $ovt_id,
            'approve_by_sup' => $approve_by_sup
        ];

        $get_emp_email = $this->Overtime_model->get_sup_email($employee_id);
        $emp_email = $get_emp_email[0]->email;

        if ($approve_by_sup == 1) {
            $msg = "Hi! <br> Your overtime request has been accepted by your supervisor. <br> Please <a href='dynatunerspeople.com'>login</a> to view the details.";
        } elseif ($approve_by_sup == 2) {
            $msg = "Hi! <br> Your overtime request has been rejected by your supervisor. <br> Please <a href='dynatunerspeople.com'>login</a> to view the details.";
        }

        $this->email->set_mailtype("html");
        $this->email->set_newline("\r\n");
        $this->email->set_crlf("\r\n");
        $this->email->from(FROM_EMAIL);
        $this->email->to($emp_email);
        $this->email->subject("Overtime Request");
        $this->email->message($msg);
        $this->email->send();

        $status_update = $this->db->where('ovt_id', $postData["ovt_id"])
            ->update("employee_overtime", $postData);

        if ($status_update) {
            $this->session->set_flashdata('message', display('save_successfully'));
            redirect("employee_overtime/Overtime/overtime_requests");
        } else {
            $this->session->set_flashdata('exception', "Something went wrong!");
            redirect("employee_overtime/Overtime/overtime_requests");
        }
    }

    public function admin_overtime()
    {
        $data['title'] = "Overtimes";
        $data['overtimes'] = $this->Overtime_model->get_admin_overtime();
        $data['module'] = "employee_overtime";
        $data['page'] = "admin_overtime";
        echo Modules::run('template/layout', $data);
    }
}