<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Overtime_model extends CI_Model
{
    public function get_employee_details($id)
    {
        $this->db->select("*");
        $this->db->from('employee_history');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();
    }

    public function create_overtime($data = [])
    {
        $create = $this->db->insert('employee_overtime', $data);
        return $create;
    }

    public function get_overtime_details($id)
    {
        $this->db->select("*");
        $this->db->from('employee_overtime');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_overtime_requests($id)
    {
        $this->db->select('employee_overtime.* ,employee_history.*');
        $this->db->join('employee_history', 'employee_history.employee_id = employee_overtime.employee_id');
        $this->db->where('sup_id', $id);
        $this->db->from('employee_overtime');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_admin_overtime_requests($id)
    {
        $this->db->select('employee_overtime.* ,employee_history.*');
        $this->db->join('employee_history', 'employee_history.employee_id = employee_overtime.employee_id');
        $this->db->where('sup_id', 0);
        $this->db->or_where('sup_id', $id);
        $this->db->from('employee_overtime');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_admin_overtime()
    {
        $this->db->select('employee_overtime.* ,employee_history.*');
        $this->db->join('employee_history', 'employee_history.employee_id = employee_overtime.employee_id');
        $this->db->where('approve_by_sup', 1);
        $this->db->from('employee_overtime');
        $query = $this->db->get();
        return $query->result();
    }

    public function get_sup_email($id)
    {
        $this->db->select("email");
        $this->db->from('employee_history');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();
    }

    public function get_employee($id)
    {
        $this->db->select("*");
        $this->db->from('employee_history');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();
    }

}