<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="panel panel-bd lobidrag">
            <div class="panel-heading">
                <div class="panel-title">
                    <h4><?php echo(!empty($title) ? $title : null) ?></h4>
                </div>
            </div>
            <div class="panel-body">

                <?php echo form_open_multipart('employee_overtime/Overtime/create_overtime', 'class="form-inner"') ?>

                <div class="form-group row">
                    <label for="ovt_start_date"
                           class="col-xs-3 col-form-label"><?php echo "Start Date" ?> </label>
                    <div class="col-xs-9">
                        <input name="ovt_start_date" type="text"
                               class="form-control ovt_dates" id="ovt_start_date"
                               placeholder="<?php echo "Start Date" ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="ovt_start_time"
                           class="col-xs-3 col-form-label"><?php echo "Start Time" ?> </label>
                    <div class="col-xs-9">
                        <input class="form-control Time1" type="time"  name="ovt_start_time"  placeholder="<?php echo "Start Time" ?>" />
                    </div>
                </div>

                <div class="form-group row">
                    <label for="ovt_end_date"
                           class="col-xs-3 col-form-label"><?php echo "End Date" ?> </label>
                    <div class="col-xs-9">
                        <input name="ovt_end_date" type="text"
                               class="form-control ovt_dates" id="ovt_end_date"
                               placeholder="<?php echo "End Date" ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="ovt_end_time"
                           class="col-xs-3 col-form-label"><?php echo "End Time" ?> </label>
                    <div class="col-xs-9">
                        <input class="form-control Time2" type="time" name="ovt_end_time"  name="ovt_end_time"  placeholder="<?php echo "End Time" ?>"/>
                    </div>
                </div>

                <div class="hours" style="color:green ; text-align: center; margin-bottom:10px; font-weight:bold;"></div>

                <div class="form-group row">
                    <label for="ovt_reason"
                           class="col-xs-3 col-form-label"><?php echo "Reason" ?> </label>
                    <div class="col-xs-9">
                        <textarea class="form-control" name="ovt_reason" placeholder="Type your reason for the overtime"
                                  id="ovt_reason"></textarea>
                    </div>
                </div>

                <?php
                foreach ($emp_details as $emp) { ?>
                    <input type="hidden" name="supervisor_id" value="<?php echo $emp->super_visor_id ?>">
                    <input type="hidden" name="employee_id" value="<?php echo $emp->employee_id ?>">
                <?php } ?>


                <div class="form-group form-group-margin text-right">
                    <button type="reset" class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                    <button type="submit" class="btn btn-success w-md m-b-5"
                            onclick="return confirm('<?php echo "Are you sure to submit. You cannot edit after submission." ?>') "><?php echo "Submit" ?></button>
                </div>

                <?php echo form_close() ?>
            </div>

        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $(".ovt_dates").datepicker({
            dateFormat: 'yy-mm-dd',
            maxDate: "+1dd"
        });
    });
    function calculate() {
        var time1 = $(".Time1").val().split(':'), time2 = $(".Time2").val().split(':');
        var start_date = $('#ovt_start_date').val();
        var end_date = $('#ovt_end_date').val();
        if(time1 != 0 && time2 != 0 && start_date != 0 && end_date !=0){
            if(start_date <= end_date){
                var hours1 = parseInt(time1[0], 10),
                    hours2 = parseInt(time2[0], 10),
                    mins1 = parseInt(time1[1], 10),
                    mins2 = parseInt(time2[1], 10);
                var hours = hours2 - hours1, mins = 0;
                var start = new Date(start_date);
                var end = new Date(end_date);
                var diffDate = (end - start) / (1000 * 60 * 60 * 24);
                var days = Math.round(diffDate);
                if(days > 0 ){
                    hours = hours +( days * 24);
                }
                // get hours
                if(hours < 0) hours = 24 + hours;
                // get minutes
                if(mins2 >= mins1) {
                    mins = mins2 - mins1;
                }
                else {
                    mins = (mins2 + 60) - mins1;
                    hours--;
                }
                // convert to fraction of 60
                mins = mins / 60;
                hours += mins;
                hours = hours.toFixed(2);
                var min = hours[hours.length-2] + hours[hours.length-1];
                min = (min/100) * 60;
                min = min.toFixed(0);
                var i = 0;
                var hourss = "";
                while(hours[i] != "."){
                    hourss = hourss + hours[i];
                    i++;
                }
                $('.hours').text("Your Total Overtime Will Be: "+ hourss +" Hours " + min + " Minutes");
            }
            else{
                alert("Please Enter The Correct Dates");
            }
        }
        else{
            alert("Please Fill All Of The Above Fields");
        }
    }
    $(".Time2").change(calculate);
</script>