<?php
$ip = $_SERVER['REMOTE_ADDR'];
$ipInfo = file_get_contents('http://ip-api.com/json/' . $ip);
$ipInfo = json_decode($ipInfo);
$timezone = $ipInfo->timezone;
date_default_timezone_set($timezone);
$current_datetime = date('Y-m-d H:i:s');
$current_date = date('Y-m-d', strtotime("$current_datetime"));
$current_time = date('H:i:s', strtotime("$current_datetime"));
?>
<style>
    .str_time{
        background-color: #f8d7da;
        color: #9d0445;
    }
</style>
<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="panel panel-bd">

            <div class="panel-heading">
                <div class="panel-title">
                    <h4><?php echo "Filter" ?></h4>
                </div>
            </div>

            <div class="panel-body">
                <?php echo form_open('employeeattendance/Attendance/attendance_log', array('class' => 'form-inline', 'method' => 'post')) ?>

                <div style="display: inline-flex;" class="form-group form-group-new">
                    <label for="employee_id"><?php echo "Select Employee" ?> :</label>
                    <select name="employee_id" class="form-control">
                        <option value="">Select One</option>
                        <?php foreach ($emplist as $emp) { ?>
                            <option value="<?php echo $emp->employee_id ?>"><?php echo $emp->first_name . ' ' . $emp->last_name ?></option>
                        <?php } ?>
                    </select>
                </div>

                <div class="form-group form-group-new">
                    <label for="start_date"><?php echo display('start_date') ?> :</label>
                    <input type="text" name="start_date" value="<?php echo date('Y-m-d') ?>"
                           class="datepicker form-control"/>
                </div>
                <div class="form-group form-group-new">
                    <label for="end_date"><?php echo display('end_date') ?> :</label>
                    <input type="text" class="datepicker form-control" name="end_date"
                           value="<?php echo date('Y-m-d') ?>"/>
                </div>
                <button type="submit" class="btn btn-success"><?php echo display('search') ?></button>

                <?php echo form_close() ?>
            </div>


        </div>
    </div>
</div>

<div class="row">
    <!--  table area -->
    <div class="panel-title bulk_add_emp_btn float-right">
        <button type="button" class="btn btn-success btn-md" data-toggle="modal" data-target="#atten_Modal">Import Bulk
            Attendance
        </button>
    </div>
    <div class="col-sm-12">

        <div class="panel panel-bd">

            <div class="panel-heading">
                <div class="panel-title">
                    <h4>
                        <?php echo "Attendance Log" ?>
                    </h4>
                </div>
            </div>

            <div class="panel-body">
                <table width="100%" class="datatable table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th><?php echo display('cid') ?></th>
                        <th><?php echo "Employee Name" ?></th>
                        <th><?php echo "Check in Date" ?></th>
                        <th><?php echo "Check in Time" ?></th>
                        <th><?php echo "Check out Date" ?></th>
                        <th><?php echo "Check out Time" ?></th>
                        <th><?php echo "Total Hours (HH:MM)" ?></th>
                        <th><?php echo "Shift Time" ?></th>
                        <th><?php echo "Action" ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if (!empty($mang)) { ?>
                        <?php $sl = 1; ?>
                        <?php foreach ($mang as $row) {
                            $check_out_datetime = date('Y-m-d H:i:s', strtotime("$row->check_out_date $row->check_out_time"));
                            $total_time = $row->total_hours;
                            $hour = floor($total_time);
                            $minute = round(($total_time - $hour) * 60);
                            $late = $row->late;
                            $shift_time = $row->employee_shift_time;
                            ?>
                            <?php if($late == 1){ ?>
                                <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                    <td  class = "str_time"><?php echo $sl; ?></td>
                                    <td  class = "str_time"><?php echo $row->first_name . " " . $row->last_name; ?></td>
                                    <td  class = "str_time"><?php echo $row->check_in_date; ?></td>
                                    <td  class = "str_time"><?php echo $row->check_in_time; ?></td>
                                    <?php
                                    if ($current_datetime < $check_out_datetime) {
                                        $check_out_date = '';
                                    } else {
                                        $check_out_date = $row->check_out_date;
                                    }
                                    ?>
                                    <td  class = "str_time"><?php echo $check_out_date; ?></td>
                                    <?php
                                    if ($current_datetime < $check_out_datetime) {
                                        $check_out_time = '';
                                    } else {
                                        $check_out_time = $row->check_out_time;
                                    }
                                    ?>
                                    <td  class = "str_time"><?php echo $check_out_time; ?></td>
                                    <?php
                                    if ($current_datetime < $check_out_datetime) {
                                        $hours = '';
                                        $minutes = '';
                                    } else {
                                        $hours = $hour;
                                        $minutes = $minute;
                                    }
                                    ?>
                                    <td  class = "str_time"><?php echo $hours . ':' . $minutes; ?></td>
                                    <td  class = "str_time"><?php echo $shift_time; ?></td>
                                    <td>
                                        <a href="<?php echo base_url() ?>employeeattendance/Attendance/edit_attendance/<?php echo $row->att_id ?>"
                                           class="btn btn-sm btn-warning">Edit</a></td>
                                </tr>
                            <?php } else{ ?>
                                <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                    <td><?php echo $sl; ?></td>
                                    <td><?php echo $row->first_name . " " . $row->last_name; ?></td>
                                    <td><?php echo $row->check_in_date; ?></td>
                                    <td><?php echo $row->check_in_time; ?></td>
                                    <?php
                                    if ($current_datetime < $check_out_datetime) {
                                        $check_out_date = '';
                                    } else {
                                        $check_out_date = $row->check_out_date;
                                    }
                                    ?>
                                    <td><?php echo $check_out_date; ?></td>
                                    <?php
                                    if ($current_datetime < $check_out_datetime) {
                                        $check_out_time = '';
                                    } else {
                                        $check_out_time = $row->check_out_time;
                                    }
                                    ?>
                                    <td><?php echo $check_out_time; ?></td>
                                    <?php
                                    if ($current_datetime < $check_out_datetime) {
                                        $hours = '';
                                        $minutes = '';
                                    } else {
                                        $hours = $hour;
                                        $minutes = $minute;
                                    }
                                    ?>
                                    <td><?php echo $hours . ':' . $minutes; ?></td>
                                    <td><?php echo $shift_time; ?></td>
                                    <td>
                                        <a href="<?php echo base_url() ?>employeeattendance/Attendance/edit_attendance/<?php echo $row->att_id ?>"
                                           class="btn btn-sm btn-warning">Edit</a></td>
                                </tr>


                            <?php } ?>
                            <?php $sl++; ?>
                        <?php } ?>
                    <?php } ?>
                    </tbody>
                </table>  <!-- /.table-responsive -->
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="panel panel-bd lobidrag">
            <div class="panel-heading">
                <div class="panel-title">
                    <h4><?php echo "Overtime Logs" ?></h4>
                </div>
            </div>
            <div class="panel-body">
                <table width="100%" class="datatable table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th><?php echo 'Name' ?></th>
                        <th><?php echo 'Start Date' ?></th>
                        <th><?php echo 'Start Time' ?></th>
                        <th><?php echo 'End Date' ?></th>
                        <th><?php echo 'End Time' ?></th>
                        <th><?php echo 'Reason' ?></th>
                        <th><?php echo 'Total Time (HH:MM)' ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if (!empty($overtimes)) { ?>
                        <?php $sl = 1; ?>
                        <?php foreach ($overtimes as $row) {
                            if ($row->approve_by_sup == 1) {
                                $approval = 'Approved';
                            } else if ($row->approve_by_sup == 0) {
                                $approval = 'Rejected';
                            } else {
                                $approval = 'Pending';
                            }

                            $total_time = $row->total_time;
                            $hour = floor($total_time);
                            $minute = round(($total_time - $hour) * 60);
                            ?>
                            <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                <td class="center">
                                    <p><?php echo $row->first_name . " " . $row->last_name ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_start_date ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_start_time ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_end_date ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_end_time ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $row->ovt_reason ?></p>
                                </td>
                                <td class="center">
                                    <p><?php echo $hour . ":" . $minute ?></p>
                                </td>
                            </tr>
                            <?php $sl++; ?>
                        <?php } ?>
                    <?php } ?>
                    </tbody>
                </table>  <!-- /.table-responsive -->

                <?php
                if (!empty($mang)) {
                    $total_att_time = '';
                    foreach ($mang as $row) {
                        $total_time = $row->total_hours;
                        $total_att_time += $total_time;
                    }
                }
                if (!empty($overtimes)) {
                    $total_ovt_time = '';
                    foreach ($overtimes as $row) {
                        $totalTime = $row->total_time;
                        $total_ovt_time += $totalTime;
                    }
                }

                $time = $total_att_time + $total_ovt_time;
                $hour = floor($time);
                $minute = round(($time - $hour) * 60);

                $overtime = $total_ovt_time;
                $overtime_hour = floor($overtime);
                $overtime_minute = round(($overtime - $overtime_hour) * 60);
                ?>
                <?php
                if ($filter_enable == 1) { ?>
                    <p class="text-center" style="margin-bottom: 20px;">Total Overtime: <b><?php echo $overtime_hour ?>
                            Hours</b> and
                        <b><?php echo $overtime_minute ?> minutes</b></p>
                    <p class="text-center" style="margin-bottom: 20px;">Total time for this employee is
                        <b><?php echo $hour ?> Hours</b>
                        and
                        <b><?php echo $minute ?> minutes</b> Including Overtime</p>
                <?php }
                ?>


            </div>
        </div>
    </div>
</div>

<!-- Import Modal -->
<div class="modal fade" id="atten_Modal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Add Employees Attendance</h4>
            </div>
            <div class="modal-body">
                <?php echo form_open_multipart('employeeattendance/Attendance/attendence_import_csv') ?>
                <input type="file" name="upload_csv_file" id="empfile"><br><br>
                <p><a href="<?php echo base_url('assets/files/emp_attendence.csv') ?>">Click here to download the
                        sample file</a></p>
                <p><b>Note:</b> <span class="text-danger">Employee file data format must be as given sample file.</span>
                </p><br>
                <input type="submit" name="submit" value="UPLOAD" class="btn btn-success">
                <?php echo form_close() ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>