<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Candidate_select extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Selection_model',
        ));
        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function candidate_shortlist_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();
        $data['title'] = display('shortlist');;
        $data['shortlist'] = $this->Selection_model->viewShortlist();
        $data['dropdowncanid'] = $this->Selection_model->dropdowncanid();
        $data['dropdown'] = $this->Selection_model->dropdown();
        $data['module'] = "recruitment";
        $data['page'] = "shortlist_view";
        echo Modules::run('template/layout', $data);
    }

    public function intern_shortlist_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();
        $data['title'] = display('shortlist');;
        $data['shortlist'] = $this->Selection_model->internViewShortlist();
        $data['dropdowncanid'] = $this->Selection_model->interndropdowncanid();
        $data['dropdown'] = $this->Selection_model->dropdown();
        $data['module'] = "recruitment";
        $data['page'] = "intern_shortlist_view";
        echo Modules::run('template/layout', $data);
    }

    public function candidate_final_shortlist_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();
        $data['title'] = "Final Shortlist";
        $data['shortlist'] = $this->Selection_model->viewFinalShortlist();
        $data['dropdowncanid'] = $this->Selection_model->dropdownfinalcanid();
        $data['dropdown'] = $this->Selection_model->dropdown();
        $data['module'] = "recruitment";
        $data['page'] = "final_shortlist_view";
        echo Modules::run('template/layout', $data);
    }

    public function create_shortlist()
    {
        $data['title'] = display('candidateshortlist');
        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|is_unique[candidate_shortlist.can_id]|max_length[50]');
        $this->form_validation->set_rules('job_adv_id', display('job_adv_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('date_of_shortlist', display('date_of_shortlist'), 'required|max_length[50]');
        $this->form_validation->set_rules('interview_date', display('interview_date'), 'max_length[100]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'can_id' => $this->input->post('can_id', true),
                'job_adv_id' => $this->input->post('job_adv_id', true),
                'date_of_shortlist' => $this->input->post('date_of_shortlist', true),
                'interview_date' => $this->input->post('interview_date', true),
                'shortlisted_by' => $this->input->post('shortlisted_by', true),
            ];

            if ($this->Selection_model->shortlist_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("recruitment/Candidate_select/create_shortlist");

        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "shortlist_form";
            $data['emplist'] = $this->Selection_model->emp_list_dropdown();
            $data['dropdowncanid'] = $this->Selection_model->dropdowncanid();
            $data['dropdown'] = $this->Selection_model->dropdown();
            $data['shortlist'] = $this->Selection_model->viewShortlist();
            echo Modules::run('template/layout', $data);

        }
    }

    public function intern_create_shortlist()
    {
        $data['title'] = display('candidateshortlist');
        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|is_unique[candidate_shortlist.can_id]|max_length[50]');
        $this->form_validation->set_rules('job_adv_id', display('job_adv_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('date_of_shortlist', display('date_of_shortlist'), 'required|max_length[50]');
        $this->form_validation->set_rules('interview_date', display('interview_date'), 'max_length[100]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'can_id' => $this->input->post('can_id', true),
                'job_adv_id' => $this->input->post('job_adv_id', true),
                'dept_id' => $this->input->post('dept_id', true),
                'date_of_shortlist' => $this->input->post('date_of_shortlist', true),
                'interview_date' => $this->input->post('interview_date', true),
                'shortlisted_by' => $this->input->post('shortlisted_by', true),
            ];

            if ($this->Selection_model->shortlist_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("recruitment/Candidate_select/intern_create_shortlist");

        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "intern_shortlist_form";
            $data['emplist'] = $this->Selection_model->emp_list_dropdown();
            $data['dropdowncanid'] = $this->Selection_model->interndropdowncanid();
            $data['dropdowndeptid'] = $this->Selection_model->dropdowndept();
            $data['dropdown'] = $this->Selection_model->dropdown();
            $data['shortlist'] = $this->Selection_model->internViewShortlist();
            echo Modules::run('template/layout', $data);

        }
    }

    public function create_final_shortlist()
    {
        $data['title'] = "Final Shortlist";
        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|is_unique[candidate_final_shortlist.can_id]|max_length[50]');
        $this->form_validation->set_rules('job_adv_id', display('job_adv_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('date_of_shortlist', display('date_of_shortlist'), 'required|max_length[50]');
        $this->form_validation->set_rules('interview_date', display('interview_date'), 'max_length[100]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'can_id' => $this->input->post('can_id', true),
                'job_adv_id' => $this->input->post('job_adv_id', true),
                'date_of_shortlist' => $this->input->post('date_of_shortlist', true),
                'interview_date' => $this->input->post('interview_date', true),
                'shortlisted_by' => $this->input->post('shortlisted_by', true),
                'manager' => $this->input->post('manager', true),
            ];

            if ($this->Selection_model->final_shortlist_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("recruitment/Candidate_select/create_final_shortlist");

        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "final_shortlist_form";
            $data['emplist'] = $this->Selection_model->emp_list_dropdown();
            $data['dropdowncanid'] = $this->Selection_model->dropdownfinalcanid();
            $data['dropdown'] = $this->Selection_model->dropdown();
            $data['shortlist'] = $this->Selection_model->viewFinalShortlist();
            echo Modules::run('template/layout', $data);

        }
    }

    public function delete_shortlist($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();

        if ($this->Selection_model->delete_shorlist($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('recruitment/Candidate_select/candidate_shortlist_view');
    }

    public function delete_final_shortlist($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();

        if ($this->Selection_model->delete_final_shortlist($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('recruitment/Candidate_select/candidate_final_shortlist_view');
    }

    public function update_shortlist_form($id = null)
    {
        $this->form_validation->set_rules('can_short_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('job_adv_id', display('job_adv_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('date_of_shortlist', display('date_of_shortlist'), 'required|max_length[50]');
        $this->form_validation->set_rules('interview_date', display('interview_date'), 'max_length[100]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'can_short_id' => $this->input->post('can_short_id', true),
                'can_id' => $this->input->post('can_id', true),
                'job_adv_id' => $this->input->post('job_adv_id', true),
                'dept_id' => $this->input->post('dept_id', true),
                'date_of_shortlist' => $this->input->post('date_of_shortlist', true),
                'interview_date' => $this->input->post('interview_date', true),
                'shortlisted_by' => $this->input->post('shortlisted_by', true),
            ];

            if ($this->Selection_model->update_shortlist($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("recruitment/Candidate/candidateinfo_view/");

        } else {
            $data['title'] = display('update');
            $data['emplist'] = $this->Selection_model->emp_list_dropdown();
            $data['dropdowndpt'] = $this->Selection_model->dropdowndept();
            $data['data'] = $this->Selection_model->shortlist_updateForm($id);
            $data['canlist'] = $this->Selection_model->Canlist();
            $data['module'] = "recruitment";
            $data['dropdown'] = $this->Selection_model->dropdown();
            $data['page'] = "update_short_form";
            echo Modules::run('template/layout', $data);
        }

    }

    public function update_final_shortlist_form($id = null)
    {
        $this->form_validation->set_rules('can_short_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('job_adv_id', display('job_adv_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('date_of_shortlist', display('date_of_shortlist'), 'required|max_length[50]');
        $this->form_validation->set_rules('interview_date', display('interview_date'), 'max_length[100]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'can_short_id' => $this->input->post('can_short_id', true),
                'can_id' => $this->input->post('can_id', true),
                'job_adv_id' => $this->input->post('job_adv_id', true),
                'date_of_shortlist' => $this->input->post('date_of_shortlist', true),
                'interview_date' => $this->input->post('interview_date', true),
                'shortlisted_by' => $this->input->post('shortlisted_by', true),
                'manager' => $this->input->post('manager', true),
            ];

            if ($this->Selection_model->update_final_shortlist($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("recruitment/Candidate_select/candidate_final_shortlist_view/");

        } else {
            $data['title'] = display('update');
            $data['emplist'] = $this->Selection_model->emp_list_dropdown();
            $data['data'] = $this->Selection_model->shortlist_final_updateForm($id);
            $data['canlist'] = $this->Selection_model->FinalCanlist();
            $data['module'] = "recruitment";
            $data['dropdown'] = $this->Selection_model->dropdown();
            $data['page'] = "final_update_short_form";
            echo Modules::run('template/layout', $data);
        }

    }


    /*######################## Interview Part ######################*/
    public function candidate_interview_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();

        $data['title'] = display('interview');;
        $data['interview'] = $this->Selection_model->viewInterview();
        $data['module'] = "recruitment";
        $data['page'] = "interview_view";
        echo Modules::run('template/layout', $data);
    }

    public function final_candidate_interview_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();

        $data['title'] = display('interview');;
        $data['interview'] = $this->Selection_model->viewFinalInterview();
        $data['module'] = "recruitment";
        $data['page'] = "final_interview_view";
        echo Modules::run('template/layout', $data);
    }

    public function select_interviewlist($id)
    {

        $data = $this->db->select('a.*,b.position_name')->from('candidate_shortlist a')->join('position b', 'a.job_adv_id=b.pos_id')->where('a.can_id', $id)->get()->row();

        echo json_encode($data);
    }

    public function create_interview()
    {
        $data['title'] = display('interview_list');
        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|is_unique[candidate_interview.can_id]|max_length[50]');
        $this->form_validation->set_rules('job_adv_id', display('job_adv_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('interview_date', display('interview_date'), 'required|max_length[100]');

        $this->form_validation->set_rules('interviewer_id', display('interviewer_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('interview_marks', display('interview_marks'), 'max_length[100]');
        $this->form_validation->set_rules('written_total_marks', display('written_total_marks'), 'max_length[100]');
        $this->form_validation->set_rules('mcq_total_marks', display('mcq_total_marks'), 'max_length[50]');
        $this->form_validation->set_rules('total_marks', display('total_marks'), 'max_length[50]');
        $this->form_validation->set_rules('recommandation', display('recommandation'), 'max_length[100]');
        $this->form_validation->set_rules('selection', display('selection'), 'required|max_length[30]');
        $this->form_validation->set_rules('details', display('details'), 'max_length[100]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $selection = $this->input->post('selection', true);

            $postData = [
                'can_id' => $this->input->post('can_id', true),
                'job_adv_id' => $this->input->post('job_adv_id', true),
                'interview_date' => $this->input->post('interview_date', true),
                'interviewer_id' => $this->input->post('interviewer_id', true),
                'interview_marks' => $this->input->post('interview_marks', true),
                'written_total_marks' => $this->input->post('written_total_marks', true),
                'mcq_total_marks' => $this->input->post('mcq_total_marks', true),
                'total_marks' => $this->input->post('total_marks', true),
                'recommandation' => $this->input->post('recommandation', true),
                'selection' => $selection,
                'details' => $this->input->post('details', true),
            ];

            if ($this->Selection_model->interview_create($postData)) {

                $get_latest_candidate = $this->Selection_model->getLatestCandidate();
                $can_name = $get_latest_candidate[0]->firstname . " " . $get_latest_candidate[0]->lastname;
                $can_email = $get_latest_candidate[0]->email;

                if ($selection == "No") {
                    $msg = "Hi $can_name!  <br> Sorry! You are rejected from the initial interview";
                    $this->email->set_mailtype("html");
                    $this->email->set_newline("\r\n");
                    $this->email->set_crlf("\r\n");
                    $this->email->from(FROM_EMAIL);
                    $this->email->to($can_email);
                    $this->email->subject("Recruitment");
                    $this->email->message($msg);
                    $this->email->send();
                }

                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("recruitment/Candidate_select/create_interview");
        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "interview_form";
            $data['dropdowninterview'] = $this->Selection_model->dropdowninterview();
            $data['interview'] = $this->Selection_model->viewInterview();
            echo Modules::run('template/layout', $data);

        }
    }

    public function create_final_interview()
    {
        $data['title'] = display('interview_list');
        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('job_adv_id', display('job_adv_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('interview_date', display('interview_date'), 'required|max_length[100]');

        $this->form_validation->set_rules('interviewer_id', display('interviewer_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('interview_marks', display('interview_marks'), 'max_length[100]');
        $this->form_validation->set_rules('written_total_marks', display('written_total_marks'), 'max_length[100]');
        $this->form_validation->set_rules('mcq_total_marks', display('mcq_total_marks'), 'max_length[50]');
        $this->form_validation->set_rules('total_marks', display('total_marks'), 'max_length[50]');
        $this->form_validation->set_rules('recommandation', display('recommandation'), 'max_length[100]');
        $this->form_validation->set_rules('selection', display('selection'), 'required|max_length[30]');
        $this->form_validation->set_rules('details', display('details'), 'max_length[100]');
        #-------------------------------#
        $manager_id = $this->session->userdata('employee_id');
        $user_id = $this->session->userdata('id');

        $role_id = $this->Selection_model->get_role($user_id);

        foreach ($role_id as $role) {
            if(isset($role['fk_role_id']) == '4') {
                $data['hr_flag'] = '1';
            }else{
                $data['hr_flag'] = '0';
            }
        }

        if ($this->form_validation->run() === true) {

            $selection = $this->input->post('selection', true);
            $postData = [
                'can_id' => $this->input->post('can_id', true),
                'job_adv_id' => $this->input->post('job_adv_id', true),
                'interview_date' => $this->input->post('interview_date', true),
                'interviewer_id' => $this->input->post('interviewer_id', true),
                'interview_marks' => $this->input->post('interview_marks', true),
                'written_total_marks' => $this->input->post('written_total_marks', true),
                'mcq_total_marks' => $this->input->post('mcq_total_marks', true),
                'total_marks' => $this->input->post('total_marks', true),
                'recommandation' => $this->input->post('recommandation', true),
                'selection' => $selection,
                'details' => $this->input->post('details', true),
            ];

            if ($this->Selection_model->final_interview_create($postData)) {

                $get_latest_candidate = $this->Selection_model->getLatestCandidateFinal();
                $can_name = $get_latest_candidate[0]->firstname . " " . $get_latest_candidate[0]->lastname;
                $can_email = $get_latest_candidate[0]->email;

                if ($selection == "No") {
                    $msg = "Hi $can_name!  <br> Sorry! You are rejected from the final interview";
                    $this->email->set_mailtype("html");
                    $this->email->set_newline("\r\n");
                    $this->email->set_crlf("\r\n");
                    $this->email->from(FROM_EMAIL);
                    $this->email->to($can_email);
                    $this->email->subject("Recruitment");
                    $this->email->message($msg);
                    $this->email->send();
                }

                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("recruitment/Candidate_select/create_final_interview");
        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "final_interview_form";
            $data['dropdowninterview'] = $this->Selection_model->finaldropdowninterview();
            $data['dropdowninterviewmanager'] = $this->Selection_model->finaldropdowninterviewmanager($manager_id);
            $data['interview'] = $this->Selection_model->viewFinalInterview();
            $data['manager_interview'] = $this->Selection_model->viewFinalManagerInterview($manager_id);
            echo Modules::run('template/layout', $data);

        }
    }


    public function delete_interview($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();
        if ($this->Selection_model->delete_interview($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("recruitment/Candidate_select/candidate_interview_view");
    }

    public function final_delete_interview($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();
        if ($this->Selection_model->final_delete_interview($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("recruitment/Candidate_select/final_candidate_interview_view");
    }

    public function interview_update_form($id = null)
    {
        $this->form_validation->set_rules('can_int_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('job_adv_id', display('job_adv_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('interview_date', display('interview_date'), 'required|max_length[100]');
        $this->form_validation->set_rules('interviewer_id', display('interviewer_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('interview_marks', display('interview_marks'), 'required|max_length[100]');
        $this->form_validation->set_rules('written_total_marks', display('written_total_marks'), 'required|max_length[100]');
        $this->form_validation->set_rules('mcq_total_marks', display('mcq_total_marks'), 'required|max_length[50]');
        $this->form_validation->set_rules('recommandation', display('recommandation'), 'required|max_length[100]');
        $this->form_validation->set_rules('selection', display('selection'), 'required|max_length[30]');
        $this->form_validation->set_rules('details', display('details'), 'max_length[100]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'can_int_id' => $this->input->post('can_int_id', true),
                'can_id' => $this->input->post('can_id', true),
                'job_adv_id' => $this->input->post('job_adv_id', true),
                'interview_date' => $this->input->post('interview_date', true),
                'interviewer_id' => $this->input->post('interviewer_id', true),
                'interview_marks' => $this->input->post('interview_marks', true),
                'written_total_marks' => $this->input->post('written_total_marks', true),
                'mcq_total_marks' => $this->input->post('mcq_total_marks', true),
                'recommandation' => $this->input->post('recommandation', true),
                'total_marks' => $this->input->post('total_marks', true),
                'selection' => $this->input->post('selection', true),
                'details' => $this->input->post('details', true),
            ];

            if ($this->Selection_model->update_interview($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
                redirect("recruitment/Candidate_select/create_interview");
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
                redirect("recruitment/Candidate_select/interview_update_form/" . $id);
            }

        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Selection_model->interview_updateForm($id);
            $data['module'] = "recruitment";
            $data['dropdowninterview'] = $this->Selection_model->dropdowninterview();
            $data['page'] = "update_interview_form";
            echo Modules::run('template/layout', $data);
        }

    }

    public function final_interview_update_form($id = null)
    {
        +
        $this->form_validation->set_rules('can_int_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('job_adv_id', display('job_adv_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('interview_date', display('interview_date'), 'required|max_length[100]');
        $this->form_validation->set_rules('interviewer_id', display('interviewer_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('interview_marks', display('interview_marks'), 'max_length[100]');
        $this->form_validation->set_rules('written_total_marks', display('written_total_marks'), 'max_length[100]');
        $this->form_validation->set_rules('mcq_total_marks', display('mcq_total_marks'), 'max_length[50]');
        $this->form_validation->set_rules('recommandation', display('recommandation'), 'required|max_length[100]');
        $this->form_validation->set_rules('selection', display('selection'), 'required|max_length[30]');
        $this->form_validation->set_rules('details', display('details'), 'max_length[100]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'can_int_id' => $this->input->post('can_int_id', true),
                'can_id' => $this->input->post('can_id', true),
                'job_adv_id' => $this->input->post('job_adv_id', true),
                'interview_date' => $this->input->post('interview_date', true),
                'interviewer_id' => $this->input->post('interviewer_id', true),
                'interview_marks' => $this->input->post('interview_marks', true),
                'written_total_marks' => $this->input->post('written_total_marks', true),
                'mcq_total_marks' => $this->input->post('mcq_total_marks', true),
                'recommandation' => $this->input->post('recommandation', true),
                'total_marks' => $this->input->post('total_marks', true),
                'selection' => $this->input->post('selection', true),
                'details' => $this->input->post('details', true),
            ];

            if ($this->Selection_model->update_final_interview($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
                redirect("recruitment/Candidate_select/final_candidate_interview_view");
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
                redirect("recruitment/Candidate_select/final_interview_update_form/" . $id);
            }

        } else {
            $data['title'] = "Final Interview";
            $data['data'] = $this->Selection_model->interview_final_updateForm($id);
            $data['module'] = "recruitment";
            $data['dropdowninterview'] = $this->Selection_model->dropdowninterview();
            $data['page'] = "final_update_interview_form";
            echo Modules::run('template/layout', $data);
        }

    }

    /* ##################### selection part ###########################*/

    public function candidate_selection_view()
    {
        $this->permission->module('recruitment', 'read')->redirect();

        $data['title'] = display('selection');;
        $data['selection'] = $this->Selection_model->viewSelection();
        $data['module'] = "recruitment";
        $data['page'] = "selection_view";
        echo Modules::run('template/layout', $data);
    }


    public function select_to_load($id)
    {

        $data = $this->db->select('*')->from('candidate_interview')->where('can_id', $id)->get()->row();

        echo json_encode($data);
    }


    public function create_selection()
    {
        $data['title'] = display('selectionlist');
        #-------------------------------#
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|is_unique[candidate_selection.can_id]|max_length[50]');
        $this->form_validation->set_rules('pos_id', display('pos_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('selection_terms', display('selection_terms'), 'required|max_length[100]');
        $id = $this->input->post('can_id', true);
        $employee = $this->db->select('max(employee_id) as maxid')->from('employee_history')->where('employee_id', $id)->get()->row();
        if (!empty($employee->maxid)) {
            $employee_id = $employee->maxid + 1;
        } else {
            $employee_id = 1;
        }

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'can_id' => $this->input->post('can_id', true),
                'employee_id' => $employee_id,
                'pos_id' => $this->input->post('pos_id', true),
                'selection_terms' => $this->input->post('selection_terms', true),
            ];

            $coa = $this->Selection_model->headcode();
            if ($coa->HeadCode != NULL) {
                $headcode = $coa->HeadCode + 1;
            } else {
                $headcode = "502020000001";
            }

            $c_code = $employee_id;
            $c_name = $employee->first_name . $employee->last_name;
            $c_acc = $c_code . '-' . $c_name;
            $createby = $this->session->userdata('fullname');
            $createdate = date('Y-m-d H:i:s');
            $data['aco'] = (object)$coaData = [
                'HeadCode' => $headcode,
                'HeadName' => $c_acc,
                'PHeadName' => 'Account Payable',
                'HeadLevel' => '2',
                'IsActive' => '1',
                'IsTransaction' => '1',
                'IsGL' => '0',
                'HeadType' => 'L',
                'IsBudget' => '0',
                'IsDepreciation' => '0',
                'DepreciationRate' => '0',
                'CreateBy' => $createby,
                'CreateDate' => $createdate,
            ];
            $Data1 = [
                'employee_id' => $employee_id,
                'pos_id' => $this->input->post('pos_id', true),
                'first_name' => $employee->first_name,
                'last_name' => $employee->last_name,
                'email' => $employee->email,
                'phone' => $employee->phone,
                'alter_phone' => $employee->alter_phone,
                'present_address' => $employee->present_address,
                'parmanent_address' => $employee->parmanent_address,
                'picture' => $employee->picture,
                'state' => $employee->state,
                'city' => $employee->city,
                'zip' => $employee->zip
            ];
            if ($this->Selection_model->selection_create($postData)) {
                $this->Selection_model->insert_employee($Data1);
                $this->Selection_model->create_coa($coaData);
                $this->session->set_flashdata('message', display('successfully_saved'));

                redirect("recruitment/Candidate_select/create_selection");
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
                redirect("recruitment/Candidate_select/create_selection");
            }
        } else {
            $data['title'] = display('create');
            $data['module'] = "recruitment";
            $data['page'] = "selection_form";
            $data['dropdownselection'] = $this->Selection_model->dropdownselection();
            $data['selected'] = $this->Selection_model->selected();
            $data['selection'] = $this->Selection_model->viewSelection();
            echo Modules::run('template/layout', $data);

        }
    }

    public function delete_selection($id = null)
    {
        $this->permission->module('recruitment', 'delete')->redirect();

        if ($this->Selection_model->selection_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("recruitment/Candidate_select/candidate_selection_view");
    }

    public function update_selection_form($id = null)
    {
        $this->form_validation->set_rules('can_id', display('can_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('pos_id', display('pos_id'), 'required|max_length[100]');
        $this->form_validation->set_rules('selection_terms', display('selection_terms'), 'max_length[100]');
        $employee = $this->db->select('*')->from('candidate_basic_info')->where('can_id', $id)->get()->row();
        $employee_id = $this->input->post('employee_id', true);
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'can_sel_id' => $this->input->post('can_sel_id', true),
                'can_id' => $this->input->post('can_id', true),
                'employee_id' => $employee_id,
                'pos_id' => $this->input->post('pos_id', true),
                'selection_terms' => $this->input->post('selection_terms', true),
            ];

            $Data1 = [
                'employee_id' => $employee_id,
                'pos_id' => $this->input->post('pos_id', true),
                'first_name' => $employee->first_name,
                'last_name' => $employee->last_name,
                'email' => $employee->email,
                'phone' => $employee->phone,
                'alter_phone' => $employee->alter_phone,
                'present_address' => $employee->present_address,
                'parmanent_address' => $employee->parmanent_address,
                'picture' => $employee->picture,
                'state' => $employee->state,
                'city' => $employee->city,
                'zip' => $employee->zip
            ];

            if ($this->Selection_model->update_selection($postData)) {
                $this->db->where('employee_id', $employee_id)
                    ->update("employee_history", $Data1);
                $this->session->set_flashdata('message', display('successfully_updated'));
                redirect("recruitment/Candidate_select/candidate_selection_view");
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
                redirect("recruitment/Candidate_select/update_selection_form/" . $id);
            }


        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Selection_model->selection_updateForm($id);
            $data['dropdownselection'] = $this->Selection_model->dropdownselection();
            $data['module'] = "recruitment";
            $data['page'] = "update_selection_form";
            echo Modules::run('template/layout', $data);
        }

    }

    public function get_selection()
    {
        $data['title'] = display('create');
        $data['module'] = "recruitment";
        $data['page'] = "selected_candidates";
        $data['dropdowninterview'] = $this->Selection_model->finaldropdowninterview();
        $data['interview'] = $this->Selection_model->viewFinalInterview();
        echo Modules::run('template/layout', $data);
    }

    public function send_selected_email($id)
    {
        $postData = [
            'can_int_id' => $id,
            'email_flag' => 1,
        ];

        $data['selected'] = $this->Selection_model->selected_candidate($id);
        $emp_email = $data['selected'][0]->email;

        if ($this->Selection_model->update_email_flag($postData)) {
            $msg = "Congratulation! You are selected";
            $this->email->set_mailtype("html");
            $this->email->set_newline("\r\n");
            $this->email->set_crlf("\r\n");
            $this->email->from(FROM_EMAIL);
            $this->email->to($emp_email);
            $this->email->CC('faakharshahwar@gmail.com');
            $this->email->subject("Selection By Dynatuners");
            $this->email->message($msg);
            $this->email->send();

            $this->session->set_flashdata('message', display('Email sent successfully'));

            redirect("recruitment/Candidate_select/get_selection");
        } else {
            $this->session->set_flashdata('message', display('Email not sent. Please contact to administrator.'));
            redirect("recruitment/Candidate_select/get_selection");
        }
    }


    public function randID()
    {
        $result = "";
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

        $charArray = str_split($chars);
        for ($i = 0; $i < 7; $i++) {
            $randItem = array_rand($charArray);
            $result .= "" . $charArray[$randItem];
        }
        return "E" . $result;
    }

    public function candidate_assessment()
    {

        $data['title'] = display('create');

        $this->form_validation->set_rules('can_id', "Candidate ID", 'required');
        $this->form_validation->set_rules('can_email', "Candidate Email", 'required');
        $this->form_validation->set_rules('assessment_title', "Title", 'required');
        $this->form_validation->set_rules('assessment_desc', "Description", 'required');
        $this->form_validation->set_rules('assessment_deadline', "Deadline", 'required');

        $this->load->library('myupload');
        $attachment = $this->myupload->do_upload(
            'application/modules/recruitment/assets/assessment/', 'assessment_attachment'

        );

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $can_id = $this->input->post('can_id', true);
            $can_email = $this->input->post('can_email', true);
            $deadline = $this->input->post('assessment_deadline', true);

            $postData = [
                'can_id' => $can_id,
                'can_email' => $can_email,
                'assessment_title' => $this->input->post('assessment_title', true),
                'assessment_desc' => $this->input->post('assessment_desc', true),
                'assessment_deadline' => $deadline,
                'assessment_attachment' => $attachment,
            ];

            if ($this->Selection_model->insert_assessment($postData)) {

                $emailFlag = [
                    'can_id' => $can_id,
                    'assessment_email' => 1,
                ];

                $this->Selection_model->update_assessment_email_flag($emailFlag);

                $file_path = base_url() . $attachment;
                $msg = "Complete the attached assessment by " . $deadline;

                $this->email->attach($file_path);
                $this->email->set_newline("\r\n");
                $this->email->set_crlf("\r\n");
                $this->email->from(FROM_EMAIL);
                $this->email->to($can_email);
                $this->email->subject("Offer Letter By Dynatuners");
                $this->email->message($msg);
                $this->email->send();

                $this->session->set_flashdata('message', display('Email sent successfully'));
                redirect("recruitment/Candidate_select/candidate_assessment");
            }

        } else {
            $data['module'] = "recruitment";
            $data['page'] = "assessment_form";
            $data['dropdowncanid'] = $this->Selection_model->dropdowncanid();
            $data['dropdown'] = $this->Selection_model->dropdown();
            $data['shortlist'] = $this->Selection_model->viewShortlist();
            echo Modules::run('template/layout', $data);
        }

    }

    public function intern_assessment()
    {

        $data['title'] = display('create');

        $this->form_validation->set_rules('can_id', "Candidate ID", 'required');
        $this->form_validation->set_rules('can_email', "Candidate Email", 'required');
        $this->form_validation->set_rules('assessment_title', "Title", 'required');
        $this->form_validation->set_rules('assessment_desc', "Description", 'required');
        $this->form_validation->set_rules('assessment_deadline', "Deadline", 'required');

        $this->load->library('myupload');
        $attachment = $this->myupload->do_upload(
            'application/modules/recruitment/assets/assessment/', 'assessment_attachment'

        );

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $can_id = $this->input->post('can_id', true);
            $can_email = $this->input->post('can_email', true);
            $deadline = $this->input->post('assessment_deadline', true);
            $page = $this->input->post('page', true);

            $postData = [
                'can_id' => $can_id,
                'can_email' => $can_email,
                'assessment_title' => $this->input->post('assessment_title', true),
                'assessment_desc' => $this->input->post('assessment_desc', true),
                'assessment_deadline' => $deadline,
                'assessment_attachment' => $attachment,
            ];

            if ($this->Selection_model->insert_assessment($postData)) {

                $emailFlag = [
                    'can_id' => $can_id,
                    'assessment_email' => 1,
                ];

                $this->Selection_model->update_assessment_email_flag($emailFlag);

                $file_path = base_url() . $attachment;
                $msg = "Complete the attached assessment by " . $deadline;

                $this->load->library('email');
                $this->email->attach($file_path);
                $this->email->set_newline("\r\n");
                $this->email->set_crlf("\r\n");
                $this->email->from(FROM_EMAIL);
                $this->email->to($can_email);
                $this->email->subject("Assessment");
                $this->email->message($msg);
                $this->email->send();

                $this->session->set_flashdata('message', display('Email sent successfully'));
                if ($page == 'intern') {
                    redirect("recruitment/Candidate_select/intern_assessment");
                } else {
                    redirect("recruitment/Candidate_select/candidate_assessment");
                }

            }

        } else {
            $data['module'] = "recruitment";
            $data['page'] = "intern_assessment_form";
            $data['dropdowncanid'] = $this->Selection_model->interndropdowncanid();
            $data['dropdown'] = $this->Selection_model->dropdown();
            $data['shortlist'] = $this->Selection_model->internViewShortlist();
            echo Modules::run('template/layout', $data);
        }

    }


}
