<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Contractual_agreement_controller extends MX_Controller
{
    private $Employees_model;

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->library('pdf');
        $this->load->model(array(
            'Onbording_model'
        ));
        if (! $this->session->userdata('isLogIn'))
            redirect('login');
    }
    public function contractual_agreement(){
        $data['results'] = $this->Onbording_model->view_appointment_letter_model('Contractual Agreement');
        $data['letter']  = 'ca';
        $data['module']  = "reports";
        $data['page']    = "onboarding/onboarding";
        echo Modules::run('template/layout', $data);
    }
    public function add_contractual_agreement(){
        $firstName = $this->input->post('firstname',true);
        $lastName = $this->input->post('lastname',true);
        $emp_email = $this->input->post('user_email');
        $effective_date = $this->input->post('effective_date');
        $gender = $this->input->post('gender');
        $description_of_services = $this->input->post('description_of_services');
        $payment = $this->input->post('payment');
        $address = $this->input->post('address');
        $father_name = $this->input->post('father_name');
        $cnic = $this->input->post('cnic');
        $dob = $this->input->post('dob');

        if($gender == 1){
            $gender = 'Mr';
        }elseif ($gender == 2){
            $gender = 'Miss';
        }

        $pdf_file_name = $this->add_pdf_contractual_agreement($firstName,$lastName,$gender,$effective_date,$description_of_services,$payment,$address,$father_name,$cnic,$dob);
        $pfd_file_path = base_url().'application/modules/reports/assets/documents/contractual_agreement/'.$pdf_file_name;

        $post_date= [
            'first_name' => $firstName,
            'last_name' => $lastName,
            'user_email' => $emp_email,
            'effective_date' => $effective_date,
            'father_name' => $father_name,
            'cnic' => $cnic,
            'dob' => $dob,
            'address' => $address,
            'offer_letter_path' => $pfd_file_path,
            'report_type' => 'Contractual Agreement'
        ];

        if($this->Onbording_model->crate_appointment_letter($post_date)){
            $this->email->set_mailtype("html");

            $msg = "<b><span style='font-size:12.0pt; font-family:&quot;Segoe UI&quot;,sans-serif; color:#201F1E'>Welcome to the team, $gender. $firstName $lastName!</span></b>             
            <br><br> Looking forward to having you in our family!
            <br><br><img src=".base_url()."'application/modules/reports/assets/images/thumbnail_image001.png'>";


            $this->email->attach($pfd_file_path);
            $this->email->set_newline("\r\n");
            $this->email->set_crlf("\r\n");
            $this->email->from(FROM_EMAIL); // change it to yours
            $this->email->to($emp_email); // change it to yours
//            $this->email->to('inam.ur.rehman@dynatuners.com');
            $this->email->CC('fey.ahmad@dynatuners.com');
            $this->email->subject("Contractual Agreement Dynatuners");
            $this->email->message($msg);
            $this->email->send();

            $this->session->set_flashdata('message', display('successfully_updated')); // sucess Message
        }else{
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("reports/Contractual_agreement_controller/contractual_agreement");
    }

    public function add_pdf_contractual_agreement($firstName,$lastName,$gender,$effective_date,$description_of_services,$payment,$address,$father_name,$cnic,$dob){
        $file_name = date('ymdst');
        $logo_get = file_get_contents(APPPATH."modules/reports/assets/images/MicrosoftTeams-image.png");
        $logo = base64_encode($logo_get);
        $bg_get = file_get_contents(APPPATH."modules/reports/assets/images/offer-letter-bg.png");
        $bg = base64_encode($bg_get);
        $effective_date = date('F d Y', strtotime($effective_date));
        $dob = date('F d Y', strtotime($dob));
        $html_content = '<style>
		@page {
			size: letter;
			margin: 0mm 0mm 0mm 0mm;
		}
		body {
			background-image: url(data:image;base64,'.$bg.');
			background-image-resize: 6;
			background-size: cover;
			padding: 60px 40px 20px 40px;
			font-size: 16px;
		}
        .main{
            margin-left: 20px;
            margin-top: 60px;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
            line-height: 16px;
        }
        .company{
            padding-top: 15px;
        }
        .hr{
           
            color: #0E78D9;
        }
        .web-link{
            color: #1866C7;
            
        }
        .list{
            color: #0F9196;
        }
        .position{
            padding-top: 20px;
        }
        .desc{
            padding-top: 20px;
        }
        .inner-list{
            list-style: none;
        }
        .last-text{
            padding-top: 15px;
        }
        .sse{
            padding-top: 40px;
        }
        .text-line {
			border-top: none;
			border-left: none;
			border-right: none;
			border-bottom: solid black 1px;
			padding: 4px 20px;
		}
        .header{
            margin: 0px 25px;
        }
        .first_para{
            margin: 0px 25px;
        }
        .logo-here{
            margin: 0px 25px;
        }
        .last_para{
            margin: 0px 25px;
        }
        .my_ol{
            margin: 0px 0px;
        }
        p{
            font-size: 13px;
        }
        li{
            font-size: 13px;
        }
        b{
            font-size: 14px;
        }
        
    </style>
<body>
    <div class="big-class">
    <div class="logo-here">
        <img src="data:image;base64,'.$logo.'" alt="" height="75" width="300">
    </div>
    <div class="main">
            
        <h2 class="header">Contractual Agreement</h2><br><br>
        <p class="first_para">
        This Contract for Services is made effective as of '.$effective_date.', by and between Shell Software Enterprises
        (Private) Ltd., of 31-D, Block-C, Gulberg III, Lahore, and '.$gender.'. '.$firstName.' '.$lastName.', of '.$address.'.
        </p><br>
            <ol class="my_ol">         
                <li>
                   <b> DESCRIPTION OF SERVICES.</b> <br> '.$description_of_services.'                
                </li>
                <li>
                   <b> PAYMENT.</b> <br> '.$payment.'                 
                </li>
                <li>
                   <b> TERM.</b> <br>This Contract will be automatically terminated after 30 days if not approved by the company. An email notice by one party will suffice.
                    <p> Shell Software Enterprises (Private) Ltd. reserves the right to terminate the Contract, in accordance with the law, where the deliverables aforementioned have not been achieved in the prescribed time. </p>             
                </li>
               <li>
                   <b> WORK PRODUCT OWNERSHIP.</b> Any copyrightable works, ideas, discoveries, inventions, patents, products, or other information (collectively the "Work Product") developed in whole or in part by '.$gender.'. '.$firstName.' '.$lastName.' in connection with the Services will be the exclusive property of Shell Software Enterprises (Private) Ltd. Upon request, '.$gender.'. '.$firstName.' '.$lastName.' will execute, within a reasonable period of time, all documents necessary to confirm or perfect the exclusive ownership of Shell Software Enterprises (Private) Ltd. to the Work Product.                    
                </li>
                <li>
                    <br><b>CONFIDENTIALITY.</b> <br>'.$gender.'. '.$firstName.' '.$lastName.' will not at any time or in any manner, either directly or indirectly, use for the personal benefit of him/herself, or divulge, disclose, or communicate in any manner, any information that is proprietary to Shell Software Enterprises (Private) Ltd. '.$gender.'. '.$firstName.' '.$lastName.' and his employees, agents, and representatives will protect such information and treat it as strictly confidential. This provision will continue to be effective after the termination of this Contract. Any oral or written waiver by Shell Software Enterprises (Private) Ltd. of these confidentiality obligations which allow '.$gender.'. '.$firstName.' '.$lastName.' to disclose Shell Software Enterprises (Private) Ltd.s confidential information to a third party will be limited to a single occurrence tied to the specific information disclosed to the specific third party, and the confidentiality clause will continue to be in effect for all other occurrences.
                    <br>
                    Upon termination of this Contract, '.$gender.'. '.$firstName.' '.$lastName.' will return to Shell Software Enterprises (Private) Ltd. all records, notes, documentation and other items that were used, created, or controlled by the Service Provider during the term of this Contract.
                </li>
                <li>
                    <br><b>INDEMNIFICATION.</b> <br>'.$gender.'. '.$firstName.' '.$lastName.' agrees to indemnify and hold Shell Software Enterprises (Private) Ltd. harmless from all claims, losses, expenses, fees including attorney fees, costs, and judgments that may be asserted against Shell Software Enterprises (Private) Ltd. that result from the acts or omissions of '.$gender.'. '.$firstName.' '.$lastName.' and/or '.$gender.'. '.$firstName.' '.$lastName.' and his employees, agents, or representatives.
                </li>
                <li>
                    <br><b>WARRANTY.</b> <br> '.$gender.'. '.$firstName.' '.$lastName.' shall provide his services and meet his obligations under this Contract in a timely and professional manner, using knowledge and recommendations for performing the services which meet generally acceptable standards in '.$gender.'. '.$firstName.' '.$lastName.'s service sector, and will provide a standard of care equal to, or superior to, care used by professional service providers operating in the same industry.
                </li>
                <li>
                    <b>DEFAULT.</b> <br> The occurrence of any of the following shall constitute a material default under this Contract:
                    <br><br>a) The failure to make a required payment when due.
                    <br><br>b) The insolvency or bankruptcy of either party.
                    <br><br>c) The subjection of any of either partys property to any levy, seizure, general assignment for the benefit of creditors, application or sale for or by any creditor or government agency.
                    <br><br>d) The failure to make available, or deliver the Services in the time and manner provided for in this Contract.
                </li>
                <li>
                   <br> <b>INDEPENDENT CONTRACTOR.</b> <br> Each party shall be, and act as an independent contractor and not as partner, joint venture, employee, representative or agent of the other and shall not bind nor attempt to bind the other to any contract.
                    <p>'.$gender.'. '.$firstName.' '.$lastName.' is an independent contractor and is solely responsible for all taxes, withholdings, labor obligations with his employees and other statutory or contractual obligations of any sort, including, but not limited to, workers’ compensation insurance.</p>
                    <p>'.$gender.'. '.$firstName.' '.$lastName.' agrees to defend, indemnify, and hold harmless Shell Software Enterprises (Private) Ltd. from all claims, damages, liability, attorneys’ fees and expenses.</p>
                    <p>'.$gender.'. '.$firstName.' '.$lastName.' will ensure that his employees and agents are bound to his obligations under this Agreement, with focus to service law of the Islamic Republic of Pakistan. '.$gender.'. '.$firstName.' '.$lastName.' remains directly responsible for compliance with this Agreement and its clauses.</p>
                </li>
                <li>
                   <br> <b>ASSIGNMENT.</b> <br> This Agreement and the services contemplated here under are personal to '.$gender.'. '.$firstName.' '.$lastName.', and he shall not have the right or ability to assign, transfer, or subcontract any obligation under this Agreement without the prior written consent of Shell Software Enterprises (Private) Ltd. Any attempt to do so, shall be null and void, which will result in recovering expectation damages and consequential damages by Shell Software Enterprises (Private) Ltd.
                </li>
                <li>
                  <br>  <b>REMEDIES.</b> <br> In addition to any and all other rights a party may have available according to law, if a party defaults by failing to substantially perform any provision, term or condition of this Contract (including without limitation the failure to make a monetary payment when due), the other party may terminate the Contract by providing written notice to the defaulting party. This notice shall describe with sufficient detail the nature of the default. The party receiving such notice shall have 3 days from the effective date of such notice to cure the default(s). Unless waived in writing by a party providing notice, the failure to cure the default(s) within such time period shall result in the automatic termination of this Contract.
                    <p>Upon breach of any of the terms, provisions, or conditions held under this Contract, both parties may seek remedy
                    through payment of damages, and in cases of misrepresentation, mutual mistake, or frustration of Contract, seek
                    the recission of Contract. In instances where there is part performance of the Contract by either party, the remedy
                    of quantum meruit may be availed at Court.</p>
                    <p><b>SHELL SOFTWARE ENTERPRISES (PRIVATE) LTD.S RESPONSIBILITY AND LIABILITY</b></p>
                    <p>Shell Software Enterprises (Private) Ltd. is not responsible for any damage, loss or injury caused or suffered by '.$gender.'. '.$firstName.' '.$lastName.' in compliance with his obligations. It is not responsible for the unlawful actions carried out by '.$gender.'. '.$firstName.' '.$lastName.' or his employees and/or his agents. Shell Software Enterprises (Private) Ltd. is not responsible for the obligations which '.$gender.'. '.$firstName.' '.$lastName.' has towards his employees.</p>
                    <p>In addition to any other right or remedy provided by law, if Shell Software Enterprises (Private) Ltd. fails to pay for the Services when due, '.$gender.'. '.$firstName.' '.$lastName.' has the option to treat such failure to pay as a material breach of this Contract, and may cancel this Contract and/or seek legal remedies, which include only his payment, and reasonable attorney fees. </p>
                    <p> '.$gender.'. '.$firstName.' '.$lastName.' will defend, indemnify and hold harmless (including, reasonable attorneys’ fees and costs) Shell Software Enterprises (Private) Ltd., its officers, directors and employees from and against any actual or threatened claims, suits, or proceedings arising out of, relating to, or based upon: (i) any breach by '.$gender.'. '.$firstName.' '.$lastName.' of his obligations, warranties and representations set forth in this Agreement or any SOW; and, (ii) any breach of the provisions respecting Shell Software Enterprises (Private) Ltd.s proprietary information. Shell Software Enterprises (Private) Ltd. will not be liable for any vicarious liability for any of '.$gender.'. '.$firstName.' '.$lastName.'s employees.</p>
                    <p>The property rights/copyrights over concepts, layouts, images and figures, logotypes, know-how, research studies, artistic, scientific creations, texts, expressions, methodologies, audiovisual works, translations, illustrations, drawings, photographs, processes, products, formulas, methods and improvements, or part of these, and even computer programs, algorithms, subroutines, source codes, object codes, designs, any derivations, improvements and refinements, or reduced to a tangible form put in practice or not, among any other result arising from the performance of services by '.$gender.'. '.$firstName.' '.$lastName.' (hereinafter simply referred to as "Works") are the sole property of Shell Software Enterprises (Private) Ltd., for all legal purposes, created by Shell Software Enterprises (Private) Ltd. s order.</p>
                    <p>Being the owner of such intellectual property rights/copyrights, Shell Software Enterprises (Private) Ltd. may use and exploit such Works, in Pakistan and abroad, irrevocably and exclusively, granting Shell Software Enterprises (Private) Ltd.s right to modify, translate into any language, edit, publish, display, reproduce, adapt, distribute, practice, transmit and/or disclose, license and/or transfer to third parties such Works and/or such rights, including them as part of derivative works and/or collective, organized by third parties or by Shell Software Enterprises (Private) Ltd., at any time.</p>
                </li>
                <li>
                    <b>FORCE MAJEURE.</b> <br> If performance of this Contract or any obligation under this Contract is prevented, restricted, or interfered with by causes beyond either partys reasonable control ("Force Majeure"), and if the party unable to carry out its obligations gives the other party prompt written notice of such event, then the obligations of the party invoking this provision shall be suspended to the extent necessary by such event. The term Force Majeure shall include, without limitation, acts of God, fire, explosion, vandalism, storm or other similar occurrence, orders or acts of military or civil authority, or by national emergencies, insurrections, riots, or wars, or strikes, lock-outs, work stoppages, or supplier failures. The excused party shall use reasonable efforts under the circumstances to avoid or remove such causes of non-performance and shall proceed to perform with reasonable dispatch whenever such causes are removed or ceased. An act or omission shall be deemed within the reasonable control of a party if committed, omitted, or caused by such party, or its employees, officers, agents, or affiliates.
                </li>
                <li>
                   <br> <b>DISPUTE RESOLUTION.</b><br>The parties will attempt to resolve any dispute out of or relating to this Agreement through friendly negotiations amongst the parties. If the matter is not resolved by negotiation, the parties will resolve the dispute using the below Alternative Dispute Resolution (ADR) procedure.
                    <p>Any controversies or disputes arising out of or relating to this Agreement will be submitted to mediation in accordance with any statutory rules of mediation. If mediation is not successful in resolving the entire dispute or is unavailable, any outstanding issues will be submitted to final and binding arbitration. The arbitrators award will be final, and judgment may be entered upon it by any court having proper jurisdiction.</p>
                </li> <br>
                <li> 
                    <b>ENTIRE AGREEMENT.</b> This Contract contains the entire agreement of the parties, and there are no other promises or conditions in any other agreement whether oral or written concerning the subject matter of this Contract. This Contract supersedes any prior written or oral agreements between the parties.
                </li> <br><br>
                <li> 
                    <b>SEVERABILITY.</b> If any provision of this Contract will be held to be invalid or unenforceable for any reason, the remaining provisions will continue to be valid and enforceable. If a court finds that any provision of this Contract is invalid or unenforceable, but that by limiting such provision it would become valid and enforceable, then such provision will be deemed to be written, construed, and enforced as so limited.
                </li> <br> <br>
                <li> 
                    <b>AMENDMENT.</b> This Contract may be modified or amended in writing by mutual agreement between the parties, if the writing is signed by the party obligated under the amendment.
                </li> <br><br>
                <li> 
                    <b>GOVERNING LAW.</b> This Contract shall be construed in accordance with the laws of the Islamic Republic of Pakistan.
                </li><br><br>        
                <li> 
                    <b>NOTICE</b>. Any notice or communication required or permitted under this Contract shall be sufficiently given if delivered in person or by certified mail, return receipt requested, to the address set forth in the opening paragraph or to such other address as one party may have furnished to the other in writing.
                </li> <br><br>
                <li> 
                    <b>WAIVER OF CONTRACTUAL RIGHT.</b><br>The failure of either party to enforce any provision of this Contract shall not be construed as a waiver or limitation of that partys right to subsequently enforce and compel strict compliance with every provision of this Contract.
                </li> <br>
                <li>
                    <b>ATTORNEYS FEES TO PREVAILING PARTY.</b> In any action arising hereunder or any separate action pertaining to the validity of this Agreement, the prevailing party shall be awarded reasonable attorneys fees and costs, both in the trial court and on appeal.
                </li> <br><br>
                <li> 
                    <b>CONSTRUCTION AND INTERPRETATION.</b> 
                    <p>The rule requiring construction or interpretation against the drafter is waived. The document shall be deemed as if it were drafted by both parties in a mutual effort.</p>
                    <p>IN WITNESS WHEREOF, the parties hereto have caused this Agreement to be executed by their duly authorized representatives as of the date first above written. Representative, Shell Software Enterprises (Private) Ltd., and '.$gender.'. '.$firstName.' '.$lastName.', Service Provider, effective as of the date first above written.</p>
                    Service Recipient:<br>
                    Shell Software Enterprises (Private) Ltd. <br>
                </li>
            </ol>
            <p class="last_para">
            <br><br><br>
            By: ________________________________________

            <br><br>Representative Name

            <br><br><br><br><br><br>
            By: ________________________________________
            <br><br>
            Service Provider:
            <br>'.$gender.'. '.$firstName.' '.$lastName.'
            <br><br> 
            <b>Mention ID card details:</b>
            <br>Father Name: '.$father_name.'
            <br>Identity Number: '.$cnic.'
            <br>Date of Birth: '.$dob.'
            </p>
    </div>
</div>
    
</body>';
        $this->pdf->loadHtml($html_content);
        $this->pdf->render();
        $output = $this->pdf->output();
        file_put_contents(APPPATH.'modules/reports/assets/documents/contractual_agreement/contractual-agreement-'.$file_name.'.pdf', $output);
        return 'contractual-agreement-'.$file_name.'.pdf';
    }
    public function delete_agreement_letter($id = null){
        $this->permission->module('employee', 'delete')->redirect();
//        $device_ip = $this->deviceData()->device_ip;
        if ($this->Onbording_model->delete_employ_letter($id)) {
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("reports/Contractual_agreement_controller/contractual_agreement");
    }
}