<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Employee_controller extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'report_model',
            'Country_model'
        ));
        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function demographic_list()
    {
        $this->permission->method('reports', 'read')->redirect();
        $id = $this->input->post('employee_id');
        $data['title'] = display('demographic_info');
        #-------------------------------#       
        #
        #pagination starts
        #
        $config["base_url"] = base_url('reports/Employee_controller/demographic_list');
        $config["total_rows"] = $this->report_model->count_demographic($id);
        $config["per_page"] = 10;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last";
        $config["first_link"] = "First";
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["emp_demogr"] = $this->report_model->demographic_list($config["per_page"], $page, $id);
        $data["links"] = $this->pagination->create_links();
        #
        #pagination ends
        # 
        $data['id'] = $id;
        $data['dropdownemp'] = $this->report_model->dropdownemp();
        $data['module'] = "reports";
        $data['page'] = "demographic_list";
        echo Modules::run('template/layout', $data);
    }

    public function positional_list()
    {
        $this->permission->method('reports', 'read')->redirect();
        $id = $this->input->post('employee_id');
        $data['title'] = display('positional_info');
        #-------------------------------#       
        #
        #pagination starts
        #
        $config["base_url"] = base_url('reports/Employee_controller/positional_list');
        $config["total_rows"] = $this->report_model->count_demographic($id);
        $config["per_page"] = 10;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last";
        $config["first_link"] = "First";
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["emp_positinal"] = $this->report_model->demographic_list($config["per_page"], $page, $id);
        $data["links"] = $this->pagination->create_links();
        $data['id'] = $id;
        $data['dropdownemp'] = $this->report_model->dropdownemp();
        $data['module'] = "reports";
        $data['page'] = "positional_list";
        echo Modules::run('template/layout', $data);
    }

    // Assets Report 
    public function employee_assets()
    {
        $this->permission->method('reports', 'read')->redirect();
        $id = $this->input->post('employee_id');
        $data['title'] = display('assets_info');
        #-------------------------------#       
        #
        #pagination starts
        #
        $config["base_url"] = base_url('reports/Employee_controller/employee_assets');
        $config["total_rows"] = $this->report_model->count_equipment($id);
        $config["per_page"] = 10;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last";
        $config["first_link"] = "First";
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["assets"] = $this->report_model->equipment_maping_report($config["per_page"], $page, $id);
        $data["links"] = $this->pagination->create_links();
        #
        #pagination ends
        # 
        $data['id'] = $id;
        $data['dropdownemp'] = $this->report_model->employee_drop();
        $data['module'] = "reports";
        $data['page'] = "assets_list";
        echo Modules::run('template/layout', $data);
    }

    //Benifit information
    public function benifit_list()
    {
        $this->permission->method('reports', 'read')->redirect();
        $id = $this->input->post('employee_id');
        $data['title'] = display('benifit_info');
        #-------------------------------#       
        #
        #pagination starts
        #
        $config["base_url"] = base_url('reports/Employee_controller/positional_list');
        $config["total_rows"] = $this->report_model->count_demographic($id);
        $config["per_page"] = 10;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last";
        $config["first_link"] = "First";
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["emp_positinal"] = $this->report_model->demographic_list($config["per_page"], $page, $id);
        $data["links"] = $this->pagination->create_links();
        #
        #pagination ends
        # 
        $data['id'] = $id;
        $data['dropdownemp'] = $this->report_model->dropdownemp();
        $data['module'] = "reports";
        $data['page'] = "benifit_list";
        echo Modules::run('template/layout', $data);
    }

    public function custom_report()
    {
        $this->permission->method('reports', 'read')->redirect();
        $id = $this->input->post('employee_id');
        $data['title'] = display('customr_info');
        #-------------------------------#       
        #
        #pagination starts
        #
        $config["base_url"] = base_url('reports/Employee_controller/custom_report');
        $config["total_rows"] = $this->report_model->count_custom_data($id);
        $config["per_page"] = 10;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last";
        $config["first_link"] = "First";
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["emp_custom"] = $this->report_model->custom_report($config["per_page"], $page, $id);
        $data["links"] = $this->pagination->create_links();
        #
        #pagination ends
        # 
        $data['id'] = $id;
        $data['dropdownemp'] = $this->report_model->employee_drop();
        $data['module'] = "reports";
        $data['page'] = "custom_list";
        echo Modules::run('template/layout', $data);
    }

    public function reports_list()
    {
        $data['module'] = "reports";
        $data['page'] = "reports_list";
        echo Modules::run('template/layout', $data);
    }

    public function employee_by_department()
    {

        $this->permission->method('reports', 'read')->redirect();
        $data['title'] = "Employee Info";

        $this->form_validation->set_rules('custdpt', 'Department', 'required');

        if ($this->form_validation->run() === true) {
            $dpt = $this->input->post('custdpt', true);
            $data['employee_list'] = $this->report_model->employee_search($dpt);
            $data['dpt'] = $dpt;
        }
        $data['module'] = "reports";
        $data['page'] = "employee_list";
        $data['dropdowndept'] = $this->report_model->dropdowndept();
        echo Modules::run('template/layout', $data);
    }

    public function employee_by_department_export($dept_id)
    {
        $dpt = $dept_id;

        $employee_list = $this->report_model->employee_search($dpt);

        foreach ($employee_list as $row) {

            $employee_name = $row->first_name . ' ' . $row->last_name;
            $hire_date = $row->hire_date;

            $start_date = $row->hire_date;
            $current_date = date("Y-m-d");
            $diff = abs(strtotime($current_date) - strtotime($start_date));
            $years = floor($diff / (365 * 60 * 60 * 24));
            $worked_months = floor(($diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));

            if ($row->employee_status == 0) {
                $status = "Cancelled";
            } else if ($row->employee_status == 1) {
                $status = "Active";
            } else if ($row->employee_status == 2) {
                $status = "On Leave";
            } else if ($row->employee_status == 3) {
                $status = "Not Started";
            } else if ($row->employee_status == 4) {
                $status = "Inactive";
            }

            $data = array(
                'employee_name' => $employee_name,
                'hire_date' => $hire_date,
                'worked_months' => $worked_months,
                'status' => $status,
            );
            $employee_data[] = $data;
        }

        header("Content-type: application/csv");
        header("Content-Disposition: attachment; filename=\"Employee_by_dept" . ".csv\"");
        header("Pragma: no-cache");
        header("Expires: 0");

        $handle = fopen('php://output', 'w');
        fputcsv($handle, array("Employee Name", "Hire Date", "Worked (Months)", "Status"));

        foreach ($employee_data as $key) {
            $narray = array(
                $key["employee_name"],
                $key["hire_date"],
                $key["worked_months"],
                $key["status"]
            );
            fputcsv($handle, $narray);
        }
        fclose($handle);
        exit;
    }

    public function employee_by_birthdays()
    {
        $data['title'] = "Employee Birthdays";

        $this->form_validation->set_rules('employee_id', 'Employee Name', 'required');

        if ($this->form_validation->run() === true) {
            $employee_id = $this->input->post('employee_id', true);
            $data['employee_list'] = $this->report_model->employee_search_by_birthday($employee_id);
            $data['employee_id'] = $employee_id;
        }

        $data['employee_list'] = $this->report_model->employee_search_by_birthday();
        $data['module'] = "reports";
        $data['page'] = "employee_by_birthdays";
        $data['employees'] = $this->report_model->dropdownemp();
        echo Modules::run('template/layout', $data);
    }

    public function all_employee_birthday_export()
    {

        $employee_list = $this->report_model->employee_search_by_birthday();

        foreach ($employee_list as $row) {

            $employee_name = $row->first_name . ' ' . $row->last_name;
            $dob = $row->dob;

            $data = array(
                'employee_name' => $employee_name,
                'dob' => $dob,
            );
            $employee_data[] = $data;
        }

        header("Content-type: application/csv");
        header("Content-Disposition: attachment; filename=\"Employee_by_dept" . ".csv\"");
        header("Pragma: no-cache");
        header("Expires: 0");

        $handle = fopen('php://output', 'w');
        fputcsv($handle, array("Employee Name", "Date of Birth"));

        foreach ($employee_data as $key) {
            $narray = array(
                $key["employee_name"],
                $key["dob"],
            );
            fputcsv($handle, $narray);
        }
        fclose($handle);
        exit;
    }

    public function absent_summary()
    {
        $data['title'] = "Employee Absent Summary";

        $data['country_list'] = $this->Country_model->state();
        $data['dropdowndept'] = $this->report_model->dropdowndept();
        $data['designation'] = $this->report_model->designation();
        $data['dropdownemp'] = $this->report_model->dropdownemp();

        $data['module'] = "reports";
        $data['page'] = "absent_summary";
        echo Modules::run('template/layout', $data);
    }

    public function filter_absent_summary()
    {
        $this->form_validation->set_rules('start_date', 'Start Date', 'required');
        $this->form_validation->set_rules('to_date', 'To Date', 'required');

        $start_date = $this->input->post('start_date', true);
        $to_date = $this->input->post('to_date', true);

        if (!($this->form_validation->run()) || $start_date > $to_date) {
            $this->session->set_flashdata('exception', 'Please Check Your Dates And Try Again');
            redirect("reports/Employee_controller/absent_summary");
        }
        $work_location = $this->input->post('work_location', true);
        $department = $this->input->post('department', true);
        $employees_status = $this->input->post('employees_status', true);
        $duty_types = $this->input->post('duty_types', true);

        $employees = $this->input->post('employees', true);

        //Get Date Range
        $date_range = array();
        $format = 'Y-m-d';
        $interval = new DateInterval('P1D');
        $realEnd = new DateTime($to_date);
        $realEnd->add($interval);

        $period = new DatePeriod(new DateTime($start_date
        ), $interval, $realEnd);
        foreach ($period as $date) {
            $date_range[] = $date->format($format);
        }

        if (!empty($employees) || !empty($department) || !empty($duty_types) || !empty($employees_status) || !empty($work_location)) {
            $emp_ids = $this->report_model->get_absent_filter_emp_id($employees, $department, $duty_types, $employees_status, $work_location);
        } else {
            $emp_ids = $this->report_model->get_emp_ids();
        }

        $master_data = array();

        foreach ($emp_ids as $emp_id) {

            $child_data = array();

            array_push($child_data, $emp_id->first_name . ' ' . $emp_id->last_name);
            array_push($child_data, $emp_id->department_name);

            for ($i = 0; $i <= $date_range[$i]; $i++) {

                $check_attendance = $this->report_model->check_attendance($emp_id->employee_id, $date_range[$i]);
                $check_approved_leave = $this->report_model->check_leave($emp_id->employee_id, $date_range[$i]);
                $check_unapproved_leave = $this->report_model->check_unapproved_leave($emp_id->employee_id, $date_range[$i]);

                if ($check_attendance) {

                    $record = "Present";

                } elseif ($check_approved_leave) {

                    $record = "Approved";

                } elseif ($check_unapproved_leave) {

                    $record = "Unapproved";

                } else {
                    $sat_sun = date("D", strtotime($date_range[$i]));
                    if ($sat_sun == "Sat" || $sat_sun == "Sun") {
                        $record = "Holiday";
                    } else {
                        $record = "Uninformed";
                    }
                }
                array_push($child_data, $record);
            }
            array_push($master_data, $child_data);
        }

        $occurences = array();
        foreach ($master_data as $data) {
            $occurences[] = array_count_values($data);
        }
        $data['country_list'] = $this->Country_model->state();
        $data['dropdowndept'] = $this->report_model->dropdowndept();
        $data['designation'] = $this->report_model->designation();
        $data['dropdownemp'] = $this->report_model->dropdownemp();

        for ($i = 0; $i < sizeof($data['dropdowndept']); $i++) {
            if ($department == $data['dropdowndept'][$i]['dept_id']) {
                $department = $data['dropdowndept'][$i]['department_name'];
                break;
            }
        }

        $data['start_date'] = $start_date;
        $data['to_date'] = $to_date;
        $data['work_location'] = $work_location;
        $data['department'] = $department;
        $data['duty_types'] = $duty_types;
        $data['employees_status'] = $employees_status;
        $data['employees'] = $employees;
        $data['occurences'] = $occurences;
        $data['module'] = "reports";
        $data['page'] = "absent_summary";
        echo Modules::run('template/layout', $data);

    }

    public function attendance_summary()
    {
        $data['title'] = "Attendance Summary";


        $data['country_list'] = $this->Country_model->state();
        $data['dropdowndept'] = $this->report_model->dropdowndept();
        $data['designation'] = $this->report_model->designation();
        $data['dropdownemp'] = $this->report_model->dropdownemp();

        if ($this->form_validation->run() === true) {
            $employee_id = $this->input->post('employee_id', true);
        }
        $data['module'] = "reports";
        $data['page'] = "attendance_summary";
        echo Modules::run('template/layout', $data);
    }

    public function filter_attendance_summary()
    {

        $this->form_validation->set_rules('start_date', 'Start Date', 'required');
        $this->form_validation->set_rules('to_date', 'To Date', 'required');

        $start_date = $this->input->post('start_date', true);
        $to_date = $this->input->post('to_date', true);

        $today = date('Y-m-d');

        if (!($this->form_validation->run()) || $start_date > $to_date || $start_date > $today || $to_date > $today) {
            $this->session->set_flashdata('exception', 'Please Check Your Dates And Try Again');
            redirect("reports/Employee_controller/attendance_summary");
        }

        $work_location = $this->input->post('work_location', true);
        $department = $this->input->post('department', true);
        $duty_types = $this->input->post('duty_types', true);
        $employees_status = $this->input->post('employees_status', true);

        $employees = $this->input->post('employees', true);

        $startDate = new DateTime($start_date);
        $endDate = new DateTime($to_date);

        $difference = $endDate->diff($startDate);
        $total_days = $difference->format("%a");
        $data['country_list'] = $this->Country_model->state();
        $data['dropdowndept'] = $this->report_model->dropdowndept();
        //        $data['designation'] = $this->report_model->designation();
        $data['dropdownemp'] = $this->report_model->dropdownemp();
        $data['duty_type'] = $this->report_model->duty_type();
        $data['day_difference'] = $total_days;


        $data['attendance_report'] = $this->report_model->attendance_summary($start_date, $to_date, $work_location, $department, $duty_types, $employees_status, $employees);
        $data['leave_detail'] = $this->report_model->leave_detail();
        $data['remaining_emp'] = $this->report_model->remaining_emp($start_date, $to_date, $department, $work_location, $duty_types, $employees_status, $employees);
        $data['total_working_hr'] = $this->report_model->total_working_hr($start_date, $to_date);

        for ($i = 0; $i < sizeof($data['dropdowndept']); $i++) {
            if ($department == $data['dropdowndept'][$i]['dept_id']) {
                $department = $data['dropdowndept'][$i]['department_name'];
                break;
            }
        }

        for ($i = 0; $i < sizeof($data['duty_type']); $i++) {
            if ($duty_types == $data['duty_type'][$i]['id']) {
                $duty_types = $data['duty_type'][$i]['type_name'];
                break;
            }
        }

        $data['start_date'] = $start_date;
        $data['to_date'] = $to_date;
        $data['difference'] = $total_days;
        $data['work_location'] = $work_location;
        $data['department'] = $department;
        $data['duty_types'] = $duty_types;
        $data['employees_status'] = $employees_status;
        $data['employees'] = $employees;
        $data['module'] = "reports";
        $data['page'] = "attendance_summary";
        echo Modules::run('template/layout', $data);
    }

    public function filter_employee()
    {
        $department_id = $this->input->post('department_id', true);
        $employee = $this->db->select('employee_id,first_name,last_name')->from('employee_history')->where('dept_id', $department_id)->get()->row();
        $data = array(
            'employee' => (!empty($employee) ? $employee : 0)
        );
        echo json_encode($data);
    }

    public function attendance_report()
    {
        $this->form_validation->set_rules('from_date', 'From Date', 'required');
        $this->form_validation->set_rules('to_date', 'To Date', 'required');

        if ($this->form_validation->run() === true) {
            $from_date = $this->input->post('from_date');
            $to_date = $this->input->post('to_date');
            $employee_id = $this->input->post('employee_id');
            $dept_id = $this->input->post('dept_id');
            $duty_type = $this->input->post('duty_type');
            $employee_status = $this->input->post('employee_status');
            $state = $this->input->post('state');

            $date_range = array();
            $format = 'Y-m-d';
            $interval = new DateInterval('P1D');
            $realEnd = new DateTime($to_date);
            $realEnd->add($interval);

            $period = new DatePeriod(new DateTime($from_date
            ), $interval, $realEnd);
            foreach ($period as $date) {
                $date_range[] = $date->format($format);
            }

            if (!empty($employee_id) || !empty($dept_id) || !empty($duty_type) || !empty($employee_status) || !empty($state)) {
                $emp_ids = $this->report_model->get_filter_emp_id($employee_id, $dept_id, $duty_type, $employee_status, $state);
            } else {
                $emp_ids = $this->report_model->get_emp_ids();
            }

            $master_data = array();

            foreach ($emp_ids as $emp_id) {

                $child_data = array();
                $hours = array();
                $total_hours = 0;

                array_push($child_data, $emp_id->first_name . ' ' . $emp_id->last_name);

                for ($i = 0; $i <= $date_range[$i]; $i++) {

                    $check_attendance = $this->report_model->check_attendance($emp_id->employee_id, $date_range[$i]);
                    $check_leave = $this->report_model->check_leave($emp_id->employee_id, $date_range[$i]);

                    if ($check_attendance) {
                        $attendance = '<span style="color:green">P</span>';

                        $hours[] = $check_attendance[0]->total_hours;
                        $total_time = array_sum($hours);
                        $hour = floor($total_time);
                        $minutes = round(($total_time - $hour) * 60);;
                        $total_hours = $hour . ':' . $minutes;

                    } elseif ($check_leave) {

                        if ($check_leave[0]->leave_time == '1') {
                            if ($check_leave[0]->leave_type_id == '3') {
                                $leave = 'SL' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '4') {
                                $leave = 'CL' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '5') {
                                $leave = 'AL' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '6') {
                                $leave = 'ML' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '7') {
                                $leave = 'MTL' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '8') {
                                $leave = 'PL' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '9') {
                                $leave = 'PL' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '11') {
                                $leave = 'CO' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '12') {
                                $leave = 'Lw/oP' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '13') {
                                $leave = 'HL' . ' ' . 'HD';
                            } else if ($check_leave[0]->leave_type_id == '14') {
                                $leave = 'UL' . ' ' . 'HD';
                            }
                        } elseif ($check_leave[0]->leave_time == '2') {
                            if ($check_leave[0]->leave_type_id == '3') {
                                $leave = 'SL' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '4') {
                                $leave = 'CL' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '5') {
                                $leave = 'AL' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '6') {
                                $leave = 'ML' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '7') {
                                $leave = 'MTL' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '8') {
                                $leave = 'PL' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '9') {
                                $leave = 'PL' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '11') {
                                $leave = 'CO' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '12') {
                                $leave = 'Lw/oP' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '13') {
                                $leave = 'HL' . ' ' . 'FD';
                            } else if ($check_leave[0]->leave_type_id == '14') {
                                $leave = 'UL' . ' ' . 'FD';
                            }
                        } elseif ($check_leave[0]->leave_time == '3') {
                            if ($check_leave[0]->leave_type_id == '3') {
                                $leave = 'SL' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '4') {
                                $leave = 'CL' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '5') {
                                $leave = 'AL' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '6') {
                                $leave = 'ML' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '7') {
                                $leave = 'MTL' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '8') {
                                $leave = 'PL' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '9') {
                                $leave = 'PL' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '11') {
                                $leave = 'CO' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '12') {
                                $leave = 'Lw/oP' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '13') {
                                $leave = 'HL' . ' ' . 'Q';
                            } else if ($check_leave[0]->leave_type_id == '14') {
                                $leave = 'UL' . ' ' . 'Q';
                            }
                        }

                        $attendance = "<span style='color:blue'>$leave</span>";
                    } else {
                        $sat_sun = date("D", strtotime($date_range[$i]));
                        if ($sat_sun == "Sat" || $sat_sun == "Sun") {
                            $attendance = '<span style="color:indianred">HD</span>';
                        } else {
                            $attendance = '<span style="color:red">A</span>';
                        }
                    }
                    array_push($child_data, $attendance);
                }
                array_push($child_data, $total_hours);
                array_push($master_data, $child_data);
            }

            if (!empty($dept_id)) {
                $department_name = $this->report_model->get_dept_name($dept_id);
                $dept_name = $department_name[0]->department_name;
            } else {
                $dept_name = 'All';
            }
            if (empty($duty_type)) {
                $duty_type = 'All';
            } else if ($duty_type == '1') {
                $duty_type = 'Intern';
            } else if ($duty_type == '2') {
                $duty_type = 'Full Time';
            } else if ($duty_type == '3') {
                $duty_type = 'Part Time';
            } else if ($duty_type == '4') {
                $duty_type = 'Contractual';
            } else if ($duty_type == '5') {
                $duty_type = 'Other';
            }

            if (empty($employee_status)) {
                $employee_status = 'All';
            } else if ($employee_status == '1') {
                $employee_status = 'Active';
            } else if ($employee_status == '2') {
                $employee_status = 'On Leave';
            } else if ($employee_status == '3') {
                $employee_status = 'Not Started';
            } else if ($employee_status == '4') {
                $employee_status = 'Cancelled';
            } else if ($employee_status == '5') {
                $employee_status = 'Inactive';
            }

            if (empty($state)) {
                $states = 'All';
            } else {
                $states = $state;
            }

            $data['from_date'] = $from_date;
            $data['to_date'] = $to_date;
            $data['dept_name'] = $dept_name;
            $data['duty_type'] = $duty_type;
            $data['employee_status'] = $employee_status;
            $data['state'] = $states;

            $data['date_range'] = $date_range;
            $data['master_data'] = $master_data;
            $data['module'] = "reports";
            $data['atten_record'] = $this->report_model->get_atten_record($from_date, $to_date);
            $data['country_list'] = $this->Country_model->state();
            $data['dropdownemp'] = $this->report_model->dropdownemp();
            $data['dropdowndept'] = $this->report_model->dropdowndept();
            $data['page'] = "attendance_report";
            echo Modules::run('template/layout', $data);
        } else {
            $data['country_list'] = $this->Country_model->state();
            $data['dropdownemp'] = $this->report_model->dropdownemp();
            $data['dropdowndept'] = $this->report_model->dropdowndept();
            $data['module'] = "reports";
            $data['page'] = "attendance_report";
            echo Modules::run('template/layout', $data);
        }

    }
}

