<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Onboarding_controller extends MX_Controller
{
    private $Employees_model;

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->library('pdf');
        $this->load->model(array(
            'Onbording_model'
        ));
        if (! $this->session->userdata('isLogIn'))
            redirect('login');
    }
    public function offer_letter_controller(){
        $data['results'] = $this->Onbording_model->view_appointment_letter_model_join('1');
        $data['letter'] = '1';
        $data['designation'] = $this->Onbording_model->designation();
        $data['departments'] = $this->Onbording_model->departments();
        $data['employe']= $this->Onbording_model->view_employs();
        $data['module']      = "reports";
        $data['page']        = "onboarding/onboarding";
        echo Modules::run('template/layout', $data);
    }
    public function nda_letter_controller(){

        $data['results'] = $this->Onbording_model->view_appointment_letter_model('2');
        $data['letter']  = '2';
        $data['module']  = "reports";
        $data['page']    = "onboarding/onboarding";
        echo Modules::run('template/layout', $data);
    }
    public function contractual_agreement(){
        $data['results'] = $this->Onbording_model->view_appointment_letter_model('3');
        $data['letter']  = '3';
        $data['module']  = "reports";
        $data['page']    = "onboarding/onboarding";
        echo Modules::run('template/layout', $data);
    }
    public function add_appointment_letter(){
        $firstName = $this->input->post('firstname',true);
        $lastName = $this->input->post('lastname',true);
        $emp_email = $this->input->post('user_email');
        $joiningDate = $this->input->post('joning_date',true);
        $hiringDate = $this->input->post('hiring_date',true);
        $salary = $this->input->post('salary',true);
        $position_id = $this->input->post('position',true);
        $department_id = $this->input->post('department_id',true);
        $gender = $this->input->post('gender');
        $revised_salary = $this->input->post('revised_salary');
        $job_type = $this->input->post('job_type');
        $start_day = $this->input->post('start_day');
        $end_day = $this->input->post('end_day');
        $start_time = $this->input->post('start_time');
        $end_time = $this->input->post('end_time');
        $project_manager_id = $this->input->post('project_manager');
        $response_date = $this->input->post('response_date');

//designationn
        $designationn = $this->Onbording_model->select_designation($position_id); // Set By Inam
        $designation = $designationn[0]->position_name;
//department
        $departments = $this->Onbording_model->select_departments($department_id); // Set By Inam
        $department = $departments[0]->department_name;
//Project Manager
        $employ = $this->Onbording_model->select_employs($project_manager_id); // Set By Inam
        $project_manager = $employ[0]->first_name.' '.$employ[0]->last_name;
//gender
        if($gender == 1){
            $gender = 'Mr';
        }elseif ($gender == 2){
            $gender = 'Miss';
        }
//job type
        if($job_type == 1){
            $job_type = 'Full Time';
        }elseif ($job_type == 2){
            $job_type = 'Part Time';
        }
// start day
        if($start_day == 1){$start_day = 'Monday';}
        elseif ($start_day == 2){$start_day = 'Tuesday';}
        elseif ($start_day == 3){$start_day = 'Wednesday';}
        elseif ($start_day == 4){$start_day = 'Thursday';}
        elseif ($start_day == 5){$start_day = 'Friday';}
        elseif ($start_day == 6){$start_day = 'Saturday';}
        elseif ($start_day == 7){$start_day = 'Sunday';}
// end day
        if($end_day == 1){$end_day = 'Monday';}
        elseif ($end_day == 2){$end_day = 'Tuesday';}
        elseif ($end_day == 3){$end_day = 'Wednesday';}
        elseif ($end_day == 4){$end_day = 'Thursday';}
        elseif ($end_day == 5){$end_day = 'Friday';}
        elseif ($end_day == 6){$end_day = 'Saturday';}
        elseif ($end_day == 7){$end_day = 'Sunday';}
// start time
        if($start_time == 1){$start_time = '12:00 PM';}
        elseif ($start_time == 2){$start_time = '1:00 PM';}
        elseif ($start_time == 3){$start_time = '2:00 PM';}
        elseif ($start_time == 4){$start_time = '3:00 PM';}
        elseif ($start_time == 5){$start_time = '4:00 PM';}
        elseif ($start_time == 6){$start_time = '5:00 PM';}
        elseif ($start_time == 7){$start_time = '6:00 PM';}
        elseif ($start_time == 8){$start_time = '7:00 PM';}
        elseif ($start_time == 9){$start_time = '8:00 PM';}
        elseif ($start_time == 10){$start_time = '9:00 PM';}
        elseif ($start_time == 11){$start_time = '10:00 PM';}
        elseif ($start_time == 12){$start_time = '11:00 PM';}
        elseif ($start_time == 13){$start_time = '12:00 AM';}
        elseif ($start_time == 14){$start_time = '1:00 AM';}
        elseif ($start_time == 15){$start_time = '2:00 AM';}
        elseif ($start_time == 16){$start_time = '3:00 AM';}
        elseif ($start_time == 17){$start_time = '4:00 AM';}
        elseif ($start_time == 18){$start_time = '5:00 AM';}
        elseif ($start_time == 19){$start_time = '6:00 AM';}
        elseif ($start_time == 20){$start_time = '7:00 AM';}
        elseif ($start_time == 21){$start_time = '8:00 AM';}
        elseif ($start_time == 22){$start_time = '9:00 AM';}
        elseif ($start_time == 23){$start_time = '10:00 AM';}
        elseif ($start_time == 24){$start_time = '11:00 AM';}
// end time
        if($end_time == 1){$end_time = '12:00 PM';}
        elseif ($end_time == 2){$end_time = '1:00 PM';}
        elseif ($end_time == 3){$end_time = '2:00 PM';}
        elseif ($end_time == 4){$end_time = '3:00 PM';}
        elseif ($end_time == 5){$end_time = '4:00 PM';}
        elseif ($end_time == 6){$end_time = '5:00 PM';}
        elseif ($end_time == 7){$end_time = '6:00 PM';}
        elseif ($end_time == 8){$end_time = '7:00 PM';}
        elseif ($end_time == 9){$end_time = '8:00 PM';}
        elseif ($end_time == 10){$end_time = '9:00 PM';}
        elseif ($end_time == 11){$end_time = '10:00 PM';}
        elseif ($end_time == 12){$end_time = '11:00 PM';}
        elseif ($end_time == 13){$end_time = '12:00 AM';}
        elseif ($end_time == 14){$end_time = '1:00 AM';}
        elseif ($end_time == 15){$end_time = '2:00 AM';}
        elseif ($end_time == 16){$end_time = '3:00 AM';}
        elseif ($end_time == 17){$end_time = '4:00 AM';}
        elseif ($end_time == 18){$end_time = '5:00 AM';}
        elseif ($end_time == 19){$end_time = '6:00 AM';}
        elseif ($end_time == 20){$end_time = '7:00 AM';}
        elseif ($end_time == 21){$end_time = '8:00 AM';}
        elseif ($end_time == 22){$end_time = '9:00 AM';}
        elseif ($end_time == 23){$end_time = '10:00 AM';}
        elseif ($end_time == 24){$end_time = '11:00 AM';}

        $pdf_file_name = $this->add_pdf($firstName,$lastName,$joiningDate,$hiringDate,$salary,$designation,$department,$gender,$revised_salary,$job_type,$start_day,$end_day,$start_time,$end_time,$project_manager,$response_date);
        $pdf_file_path = base_url().'application/modules/reports/assets/documents/offer/'.$pdf_file_name;

        $post_date= [
            'first_name' => $firstName,
            'last_name' => $lastName,
            'pos_id' => $this->input->post('position',true),
            'department_id'=>$this->input->post('department_id',true),
            'joining_date'=>$joiningDate,
            'hiring_date'=>$hiringDate,
            'salary'=>$salary,
            'user_email' => $emp_email,
            'gender'=>$gender,
            'revised_salary' => $revised_salary,
            'job_type' => $job_type,
            'start_day' => $start_day,
            'end_day' => $end_day,
            'start_time' => $start_time,
            'end_time' => $end_time,
            'project_manager_id' => $project_manager,
            'response_date' => $response_date,
            'offer_letter_path' => $pdf_file_path,
            'report_type' => '1'
        ];
        if($this->Onbording_model->crate_appointment_letter($post_date)){
//        if(true){
            $this->email->set_mailtype("html");

            if($revised_salary != null){
                $set_revised_sal = ' (will be revised to Rs. '.$revised_salary.'/- upon completion of probation period, based upon performance)';
            }

            $msg = "<b><span style='font-size:12.0pt; font-family:&quot;Segoe UI&quot;,sans-serif; color:#201F1E'>Welcome to the team, $gender. $firstName $lastName!</span></b>
            <br><br> We are happy to have you on board.
            <br><br> Find attached our Offer Letter, please respond back to the email notifying the reception.
            <br><br> <b><span style='font-size:12.0pt; font-family:&quot;Segoe UI&quot;,sans-serif; color:#201F1E'>Joining Date:</span></b> $joiningDate
            <br> <b><span style='font-size:12.0pt; font-family:&quot;Segoe UI&quot;,sans-serif; color:#201F1E'>Position:</span></b>  $designation
            <br> <b><span style='font-size:12.0pt; font-family:&quot;Segoe UI&quot;,sans-serif; color:#201F1E'>Salary:</span> </b>  Rs. $salary/- per month$set_revised_sal.
            <br><br> <b><span style='font-size:12.0pt; font-family:&quot;Segoe UI&quot;,sans-serif; color:#201F1E'>NOTE:</span></b> As we already discussed and agreed upon that you will be going through your training upon joining and you will be signing a 2-year bond with the company
            <br>We will invest in you equivalent to a cost of <b>1,200,000/- PKR</b> including <b>infrastructure, facilities, setup</b>, and <b>instruction</b>.
            <br><br>Attached Offer Letter should be sent back signed as soon as possible. Please note that signing the Offer Letter are the prerequisite for the job.
            <br><br> Looking forward to having you in our family!
            <br><br> Regards,            
            <br><br><b><span style='font-family:&quot;Arial&quot;,sans-serif; color:#2F5496'>Head of Human Resource Management</span></b>
            <br><b><span style='font-size:10.0pt; font-family:&quot;Arial&quot;,sans-serif; color:#1F497D'>Instructor Brandon | Dynatuners&nbsp;</span></b>            
            <br><br><i><a href='mailto:Human.Resources@dynatuners.com' style='font-size:10.0pt; font-family:&quot;Arial&quot;,sans-serif; color:#1F497D'>Human.Resources@dynatuners.com</a></i>
            <br><i><a href='https://www.instructorbrandon.com/' style='font-size:10.0pt; font-family:&quot;Arial&quot;,sans-serif; color:#1F497D'>https://www.instructorbrandon.com/</a></i>
            <br><img src=".base_url()."application/modules/reports/assets/images/thumbnail_image001.png>";

            $this->email->set_mailtype("html");

            $this->email->attach($pdf_file_path);
            $this->email->set_newline("\r\n");
            $this->email->set_crlf("\r\n");
            $this->email->from(FROM_EMAIL); // change it to yours
            $this->email->to($emp_email); // change it to yours
//            $this->email->to('inam.ur.rehman@dynatuners.com'); // change it to yours
            $this->email->CC('fey.ahmad@dynatuners.com');
            $this->email->subject("Offer Letter By Dynatuners");
            $this->email->message($msg);
            $this->email->send();

            $this->session->set_flashdata('message', display('successfully_updated')); // sucess Message
        }
        else{
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("reports/Onboarding_controller/offer_letter_controller");
    }
    public function add_pdf($firstName,$lastName,$joiningDate,$hiringDate,$salary,$position,$department,$gender,$revised_salary,$job_type,$start_day,$end_day,$start_time,$end_time,$project_manager,$response_date)
    {
        $file_name = date('ymdst');
        $logo_get = file_get_contents(APPPATH . "modules/reports/assets/images/MicrosoftTeams-image.png");
        $logo = base64_encode($logo_get);
        $bg_get = file_get_contents(APPPATH . "modules/reports/assets/images/offer-letter-bg.png");
        $bg = base64_encode($bg_get);
        $joiningDate = date('F d , Y', strtotime($joiningDate));
        $response_date = date('F d , Y', strtotime($response_date));
        $html_content = '<style>
		@page {
			size: letter;
			margin: 0mm 0mm 0mm 0mm;
		}
		body {
			background-image: url(data:image;base64,'.$bg.');
			background-image-resize: 6;
			background-size: 100%;
			padding: 95px 83px 0px 83px;
			font-size: 16px;			
		}
        .main{
            margin-left: 20px;
            margin-top: 60px;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
        }
        .company{
            padding-top: 15px;
        }
        .hr{           
            color: #0E78D9;
        }
        .web-link{
            color: #1866C7;            
        }
        .list{
            color: #0F9196;
        }
        .position{
            padding-top: 20px;
        }
        .desc{
            padding-top: 20px;
        }
        .inner-list{
            list-style: none;
        }
        .last-text{
            padding-top: 15px;
        }
        .sse{
            padding-top: 40px;
        }
        .text-line {
			border-top: none;
			border-left: none;
			border-right: none;
			border-bottom: solid black 1px;
			padding: 4px 20px;
		}
		.logo{
		height: 65px;
		}
		p{
		    font-size: 12px;
		    color: #333E49;	
		}
		b{
		    font-size: 12px;
		    color: #333E49;	
		}
		li{
		    font-size: 12px;
		    color: #333E49;	
		}
		.header{
		 margin-top: 0px;
		 font-size: 30px;   
        font-weight: bold;		 
		}
    </style>
<body>
    <div class="big-class">
    <div class="">
        <img class="logo" src="data:image;base64,'.$logo.' alt="">
    </div>
    <div class="main" style="line-height: 15px">
        <p class="header">Employment Letter</p>
        <p><b> Dear '.$gender.'. '.$firstName.' '.$lastName.',</b><br><br>
            We’re delighted to extend this offer of employment for the position of <b> '.$position.' </b>with <b> Shell Software 
            Enterprises (Private) Ltd. </b>Please review this summary of terms and conditions for your anticipated employment
            with us.<br><br>
            If you accept this offer, your start date will be <b> '.$joiningDate.',</b> and you would report to your lead project manager 
            – '.$project_manager.' and CEO of the company – Mr. Brandon Ahmad.<br><br>
            Please find attached the terms and conditions of your employment, should you accept this offer letter. We would like 
            to have your response by <b>'.$response_date.'.</b>  In the meantime, please feel free to contact <b> '.$department.'</b>  via email if you have any questions.<br><br>
            We are all looking forward to having you on our team.</p>
            <p class="company">Best regards,<br>
                Human Resource Department <br>
               <b> Shell Software Enterprises Private Limited</b>  <br>
               <a href="" class="hr"> Human.Resources@dynatuners.com </a><br>
              <a href="" class="web-link"> www.instructorbrandon.com </a>
                <br><br><br><br>
                I. <span style="color: #00756A"> Position</span> <br>
               II. <span style="color: #00756A"> Cash compensation</span> <br>
              III. <span style="color: #00756A"> Bonus (or commission) potential</span> <br>
               IV. <span style="color: #00756A"> Employee benefits</span> <br>
                V. <span style="color: #00756A"> Privacy and confidentiality agreements</span> <br>
               VI. <span style="color: #00756A"> Termination conditions</span> <br>
              VII. <span style="color: #00756A"> Interpretation, amendment and enforcement</span> <br>
             VIII. <span style="color: #00756A"> Return of Company’s Property</span> <br>
             </p>
              <ol type="I" class="desc">
                  <p>
                  <li>
                    <b> Position </b> 
                    <br> <b>Job title</b> <br>Your title will be <b> '.$position.'</b> and you will report to your lead project manager – '.$project_manager.' 
                        and CEO of the company – Mr. Brandon Ahmad. <br>
                       <b> Working schedule</b><br>
                        This is a <b> '.$job_type.' position</b> and regular weekly schedule will be <b> '.$start_day.' to '.$end_day.' '.$start_time.'-'.$end_time.'.</b>
                        <br>
                        <p style="page-break-before: always"><b> Employment Relationship</b><br>
                        Employment with the Company is for no specific period of time. Your employment with the Company will 
                            be “at will,” meaning that either you or the Company may terminate your employment at any time and for 
                            any reason, withor without cause. Any contrary representations that may have been made to you are 
                            superseded by this letter agreement. This is the full and complete agreement between you and the Company 
                            on this term. Although your job duties, title, compensation and benefits, as well as the Company’s personnel 
                            policies and procedures, may change from time to time, the “at will” nature of your employment may only 
                            be changed in an express written agreement signed by you and a duly authorized officer of the Company
                            (other than you.)</p>
                    </li>
                    </p>
                    
                        <p>
                        <li>
                            <b> Cash Compensation </b> <br> <b>Salary</b> <br> The Company will pay you a salary of <b> Rs. '.$salary.'/- per month,</b> payable in accordance with the Company’s 
                                standard payroll schedule and there will be 3 months’ long probation period. Your salary will be revised to 
                                Rs. '.$revised_salary.'/- based upon your performance upon completion of probation period.
                            
                        </li>
                         </p>  
                         
                        <p>
                        <li>
                            <b> Bonus (or commission) potential</b> <br>In addition, you will be eligible to be considered for an incentive bonus for each fiscal year of the Company 
                                after successful completion of your one-year employment in Shell Software Enterprises. The bonus (if any) 
                                will be awarded based on objective or subjective criteria established by the Company’s Human Resource 
                                Department and approved by the <b> Company’s CEO.</b>
                   </li>
                   </p>
                   
                   <p>
                   <li>
                    <b> Employee benefits</b><br>As a regular employee of the Company, you will be eligible to participate in a number of Company sponsored benefits. <br>
                        <br>The Company offers a comprehensive employee benefits program, including:
                        <br><br>
                        <b> Medical Policy</b><br>
                        You will be eligible to avail the medical benefits as per the policy.  
                        <br><br>
                        <b> Vacation policy</b><br>
                        You will be eligible to avail leaves and vacations as per the company’s policy.
                        <br><br>
                        <b> Training and Certification</b><br>
                        Based on your enthusiasm and commitment to work and grow with the company you may stand eligible
                        for certaintraining and certification. 
                        <br>
                    </li> 
                    </p> 
                    <p>
                    <li>
                    <b> Privacy and Confidentiality <br> Privacy Agreement</b><br>You are required to observe and uphold all of the Company’s privacy policies and procedures as 
                        implemented or varied from time to time. Collection, storage, access to and dissemination of employee 
                        personal information will be in accordance with privacy legislation.
                        
                    </li>
                    </p>                    
                    <p>
                    <li>
                      <b>Conflict of Interest policy</b><br>While you are employed at this Company, you will not engage in any other employment, consulting or other
                        businessactivity (whether full-time or part-time) that would create a conflict of interest with the Company. 
                        By signing this letter of agreement, you confirm that you have no contractual commitments or other legal 
                        obligations that would prohibit you from performing your duties for the Company.
                        <br>
                      <b>Non-Disclosure Agreement</b><br>Like all Company employees, you will be required, as a condition of your employment with the Company,
                        to sign theCompany’s Non-Disclosure Agreement.
                    </li>
                    </p>                    
                    <p>
                        <li>
                            <b> Termination Conditions</b><br>The Company reserves the right to terminate employment of any employee for just cause at any time 
                                without notice and without payment in lieu of notice. The Company will be entitled to terminate your 
                                employment for any reason other than for just cause, upon providing to you such minimum notice as
                                required by law.
                        </li>
                    </p>
                        <br>                        
                        
                            <p style="page-break-before: always"> 
                            <li> <b> Interpretation, Amendment and Enforcement</b><br>This letter agreement supersedes and replaces any prior agreements, representations or understandings 
                                (whether written, oral, implied or otherwise) between you and the Company and constitute the complete 
                                agreement between you and the Company regarding the subject matter set forth herein. This letter 
                                agreement may not be amended or modified, except by an express written agreement signed by both you
                                and a duly authorized officer of the Company.
                            </li>
                            </p>
                        <br>
                        <br> 
                        <p>
                        <li>
                        <b>Return of Company’s Property</b>
                        <br>    If your employment with the Company ends for any reason, you must promptly return the Company’s 
                                property i.e., Laptop and other provided gadgets within the 03 days. Failure to follow the said instructions
                                will result in withholdingyour payroll and also the deduction of 5% will be made each day from your payroll.
                            
                        </li>
                        </p>
              </ol>
             <p class="last-text"><p> As we Already Discussed and agreed before we start your Training, you will sign Two- <br> year bond with us. we will invest in you equivalent to a cost of <b> 1,200,000 PKR </b> including <b> infrastructure, facilities,
                       setup,</b> and <b> instructions.</b> </p>
                      <p> You may indicate your agreement with these terms and accept this offer by signing and dating this agreement by <b> '.$response_date.'.</b> Upon your acceptance of this employment offer, shall enterprises will be pleased to onboard you.</p>
                    <p class="sse">
                        Sincerely, <br>
                         Human Resource Department <br>
                        <b> Shell Software Enterprises</b> Private Limited <br>
                    </p>
                    <p class="sse">Signatures:                                             </p>
                    <p class="sse"> Applicant (Sign)</p>
                    <input type="text" class="text-line" /><br>
                    <p class="sse"> Date</p>
                    <input type="text" class="text-line" />
    </div>
</div> 
</body>';
        $this->pdf->loadHtml($html_content);
        $this->pdf->render();
        $output = $this->pdf->output();
        file_put_contents(APPPATH . 'modules/reports/assets/documents/offer/offer-letter-'.$file_name.'.pdf', $output);
        return 'offer-letter-'.$file_name.'.pdf';
    }
    public function send_test_email(){
        $this->load->library('email');
        $this->email->set_mailtype("html");
        $this->email->attach(base_url().'application/modules/reports/assets/documents/offer-letter-2111174730.pdf');
        $this->email->set_newline("\r\n");
        $this->email->set_crlf("\r\n");
        $this->email->from(FROM_EMAIL); // change it to yours
        $this->email->to('inam.ur.rehman@dynatuners.com'); // change it to yours
        $this->email->subject("test mail");
        $this->email->message("<h1>this is message</h1>");
        if ($this->email->send()) {
            echo "Mail Send";
            return true;
        } else {
            show_error($this->email->print_debugger());
        }
    }
    public function add_nda_letter(){
        $firstName = $this->input->post('firstname',true);
        $lastName = $this->input->post('lastname',true);
        $emp_email = $this->input->post('user_email');
        $effective_date = $this->input->post('effective_date');
        $gender = $this->input->post('gender');

// Gender
        if($gender == 1){
            $gender = 'Mr';
        }elseif ($gender == 2){
            $gender = 'Miss';
        }

        $pdf_file_name = $this->add_pdf_nda($firstName,$lastName,$effective_date);
        $pdf_file_path = base_url().'application/modules/reports/assets/documents/nda/'.$pdf_file_name;

        $post_date= [
            'first_name' => $firstName,
            'last_name' => $lastName,
            'user_email' => $emp_email,
            'effective_date' => $effective_date,
            'offer_letter_path' => $pdf_file_path,
            'report_type' => '2'
        ];
        if($this->Onbording_model->crate_appointment_letter($post_date)){
            $this->email->set_mailtype("html");

            $msg = "<b><span style='font-size:12.0pt; font-family:&quot;Segoe UI&quot;,sans-serif; color:#201F1E'>Welcome to the team, $gender. $firstName $lastName!</span></b>
            <br><br> We are happy to have you on board.
            <br><br> Find attached our Non-Disclosure Agreement, please respond back to the email notifying the reception.
            <br><br> Attached NDA should be sent back signed as soon as possible. Please note that signing the NDA is the prerequisite for the job. 
            <br><br> Looking forward to having you in our family!
            <br><br><i><a href='mailto:Human.Resources@dynatuners.com' style='font-size:10.0pt; font-family:&quot;Arial&quot;,sans-serif; color:#1F497D'>Human.Resources@dynatuners.com</a></i>
            <br><i><a href='https://www.instructorbrandon.com/' style='font-size:10.0pt; font-family:&quot;Arial&quot;,sans-serif; color:#1F497D'>https://www.instructorbrandon.com/</a></i>
            <br><br><img src=".base_url()."application/modules/reports/assets/images/thumbnail_image001.png>";

            $this->email->set_mailtype("html");

            $this->email->attach($pdf_file_path);
            $this->email->set_newline("\r\n");
            $this->email->set_crlf("\r\n");
            $this->email->from(FROM_EMAIL); // change it to yours
            $this->email->to($emp_email); // change it to yours
//            $this->email->to('inam.ur.rehman@dynatuners.com'); // change it to yours
            $this->email->CC('fey.ahmad@dynatuners.com');
            $this->email->subject("NDA By Dynatuners");
            $this->email->message($msg);
            $this->email->send();

            $this->session->set_flashdata('message', display('successfully_updated')); // sucess Message
        }
        else{
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("reports/Onboarding_controller/nda_letter_controller");
    }
    public function add_pdf_nda($firstName,$lastName,$effective_date){
        $file_name = date('ymdst');
        $logo_get = file_get_contents(APPPATH . "modules/reports/assets/images/MicrosoftTeams-image.png");
        $logo = base64_encode($logo_get);
        $bg_get = file_get_contents(APPPATH . "modules/reports/assets/images/offer-letter-bg.png");
        $bg = base64_encode($bg_get);
        $effective_date = date('F d , Y', strtotime($effective_date));
        $html_content = '<style>
    @page {
			size: letter;
			margin: 0mm 0mm 0mm 0mm;
		}		        
		body {
			background-image: url(data:image;base64,'.$bg.');
			background-image-resize: 6;
			background-size: 100%;			
			font-size: 12px;						
		}
    .main{
        margin-left: 90px;
        margin-right: 90px;
        line-height: 19px;
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
    }
    .logo-here {
        text-align: center;
        margin-top: 200px; 
}
.img-text{
   
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
    font-weight: bold;
}
.agg{
   
    font-size: 48px;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
}
.light{
    font-style: italic;
    color: #686666;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
    font-weight: lighter;
}
.sse{
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
    font-size: 40px;
}
.dark{
      font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
}
.first-point{
 
    font-weight: bold;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
}
.sec-list{
    
}
.last-list{
    list-style: none;
}
.text-line {
    border-top: none;
    border-left: none;
    border-right: none;
    border-bottom: solid black 1px;    
}
footer {
                position: fixed; 
                bottom: -60px; 
                left: 0px; 
                right: 0px;
                height: 50px; 

                /** Extra personal styles **/
                background-color: #03a9f4;
                color: white;
                text-align: center;
                line-height: 35px;
            }

</style>

<body>
    <div class="logo-here">
        <img src="data:image;base64,'.$logo.'" alt="" width="550" style="margin-top: 130px">
        <h3 class="img-text" style="margin-top: 150px; font-size: 20px">NON-DISCLOSURE AGREEMENT <br>
            SHELL SOFTWARE ENTERPRISES
        </h3>
        <div style="position: absolute; width: 100%; bottom: 50px; text-align: center">
            <span style="color: red; font-size: 10px">This document is company confidential and may not be distributed.</span> <br>
            <span style="font-size: 14px">Shell Software Enterprises</span>
        </div>
        <h1 class="agg" style="page-break-before: always;margin-top: 110px">NON-DISCLOSURE <br>
            AGREEMENT</h1>
            <h1 class="light">between</h1>
            <h1 class="sse" style="font-size: 30px"> '.$firstName.' '.$lastName.' </h1>
            <h1 class="light" style="font-size: 24px">(herein after known as "The <br><br> 
                Employee") and</h1>
                <h1 class="sse" style="font-size: 33px">SHELL SOFTWARE ENTERPRISES</h1>
                <h1 class="light" style="font-size: 24px">(hereinafter known as “The Company”) <br><br>
                    collectively known as the “Parties” as of the</h1>
                    <h1 class="dark" style="font-size: 24px">'.$effective_date.'</h1>
                    <h1 class="light">(the “Effective Date”).</h1>
        <div style="position: absolute; width: 100%; bottom: 50px; text-align: center">
            <span style="color: red; font-size: 10px">This document is company confidential and may not be distributed.</span> <br>
            <span style="font-size: 14px">Shell Software Enterprises</span>
        </div>
    </div>
    <div class="main">
    <p class="first-point" style="page-break-before: always; margin-top: 93px">Article I: Scope of Agreement</p>
    <p>This Agreement acknowledges that certain confidential information, trade secrets, and proprietary data 
        (hereinafter defined and referred to as “Confidential Information”) of or regarding the Company may be 
        discussed between the Employee and the Company (hereinafter known collectively as the “Parties”). The 
        provisions set forth in this Agreement define the circumstances in which the Employee can and cannot 
        disclose Confidential Information, and include the remedies, penalties, and lawful action the Company may 
        take should such information be used or disclosed by Employee. Both Parties agree that it is in their best 
        interests to protect the Company’s Confidential Information, and that the terms of this Agreement create a 
        bond of trust and confidentiality between them. In consideration of Employee’s commencement of 
        employment, or continued employment with the Company, the Parties agree as follows:
        </p>
        <p> <b> Article II: Confidential Information </b> </p>
        <ol type="A" class="list">
            <li><b> Definitions.</b> Confidential Information is any material, knowledge, information and data (verbal,
                electronic, written or any other form) concerning the Company or its businesses not generally known 
                to the public consisting of, but not limited to, inventions, discoveries, plans, concepts, designs, 
                blueprints, drawings, models, devices, equipment, apparatus, products, prototypes, formulae, 
                algorithms, techniques, research projects, computer programs, software, firmware, hardware, 
                business, development and marketing plans, merchandising systems, financial and pricing data,
                information concerning investors, customers, suppliers, consultants and employees, and any other 
                concepts, ideas or information involving or related to the business which, if misused or disclosed, 
                could adversely affect the Company’s business.</li><br>
                <li><b> Exclusions.</b> For the purposes of this Agreement, information shall not be deemed Confidential 
                    Information and the Employee shall have no obligation to keep it confidential if:</li>
                    <ol type="i" class="sec-list">
                        <li>the information was publicly known.</li><br>
                        <li> the information was received from a third party not subject to the restrictions of this Agreement 
                            and becomes available to Employee through no wrongful act or breach of Agreement on their part; or</li><br>
                            <li>he information was approved for release by Employer through written authorization.</li><br>
                    </ol>
                    <li><b>Period of Confidentiality</b>
                        <p>-Employee agrees not to use or disclose Confidential Information for their own personal benefit or 
                            the benefit of any other person, corporation, or entity other than the Company during the 
                            Employee’s employment with the Company with the Shell Software Enterprises at any time</p>
                    </li><br>
                    <li><b>Limitations.</b> Employee shall limit access to Confidential Information to individuals on a strictly need-to- know basis, involving only those who are carrying out duties related to the Company and its 
                        business. Individuals under the Employee’s command (affiliates, agents, consultants, representatives, 
                        and other employees) are bound by and shall comply with the terms of this Agreement.
                        </li><br>
                        </div>
                        <div style="position: absolute; width: 100%; bottom: 50px; text-align: center">
                            <span style="color: red; font-size: 10px">This document is company confidential and may not be distributed.</span> <br>
                            <span style="font-size: 14px">Shell Software Enterprises</span>
                            </div>
                        <div class="main">
                        <li style="page-break-before: always ; margin-top: 93px"><b>Ownership.</b> All information containing or in any way relating to Confidential Information is considered 
                            property of the Employer. The removal of Confidential Information from the Company’s premises is 
                            prohibited unless prior written consent is provided by the Company. All such items made, compiled, or 
                            used by the Employee shall be delivered to the Employer by Employee upon termination of employment 
                            or at any other time as per the Employer’s request.</li><br>
        </ol>
        <p><b>Article III: Inventions</b></p>
        <ol type="A">
            <li><b>Prior inventions.</b> Any inventions created or conceptualized by the Employee prior to signing the 
                Agreement are excluded from the provisions herein.</li><br>
                <li><b> Ownership of Inventions.</b> Inventions constructed while under the Company’s employment are the 
                    sole property of the Company except those described under subsection (C) of this section. C. Personal 
                    Inventions. Inventions developed by Employee on their own personal time not constructed on Company 
                    property, and that were not created using any Company materials, equipment, technology, or information, 
                    are exempt from the provisions of the Agreement.</li>
        </ol>
        <p><b>Article IV: Entire Agreement</b></p>
        <ol type="A">
            <li><b> Previous Agreements.</b> This Agreement constitutes the entire agreement and the signing thereof by 
                both Parties nullifies all previous agreements made between Employer and Employee.</li><br>
                <li><b> Modifications and Amendments.</b> No modifications, amendments, changes, or alterations can be 
                    made to the Agreement unless in writing and signed by authorized representatives of both Parties.</li><br>
                    <li><b>Successors and Assigns</b>
This Agreement shall be binding upon the successors, subsidiaries, 
assigns, and corporations controlling or controlled by the Parties. The Company may assign this 
Agreement to any party at any time, whereas Employee is prohibited from assigning any of their rights or 
obligations in the Agreement without prior written consent from Company.
                    </li><br>
        </ol>
        <p><b>Article V: Nature of Relationship</b></p>
        <ol type="A">
            <li><b>Non-contract.</b>The Agreement does not constitute a contract of employment, nor does it guarantee 
                continuing employment for the Employee.</li><br>
                <li><b>Non-partner. </b>The Agreement does not create a partnership or joint venture between Company and 
                    Employee. Any financial arrangements made between both Parties shall not be included in this 
                    Agreement but must be disclosed in a separate document.
                    </li>
        </ol>
        <p><b>Article VI: Severability</b></p>
        <p>Any provision within the Agreement (or any portion thereof) deemed invalid, unlawful, or otherwise 
            unusable by a court of law shall be dissolved from the Agreement and the remainder of the Agreement 
            shall continue to be enforceable. A severed provision shall not alter the integrity of the Agreement, and 
            the terms set forth in any severed provision shall be construed in such a way as to interpret the purpose 
            for which it was drafted.</p>
            </div>
            <div style="position: absolute; width: 100%; bottom: 50px; text-align: center; margin-left: 0px">
                <span style="color: red; font-size: 10px">This document is company confidential and may not be distributed.</span> <br>
                <span style="font-size: 14px">Shell Software Enterprises</span>
            </div>
            <div class="main">
            <p style="page-break-before: always;margin-top: 93px"><b>Article VII: </b> </p>
            <ul class="last-list">
                <li><b>Governing Law</b>  This Agreement shall be governed in accordance with the laws of the Islamic Republic of 
                    Pakistan</li>
            </ul>
            <p><b>Article VIII: Immunity</b></p>
            <p>Disclosing Confidential Information to an attorney, government representative or court official in 
                confidence while assisting or taking part in a case involving a suspected violation of law is not considered 
                a breach of this Agreement. Should the Employee be required to disclose Confidential Information by law, 
                the Employee shall provide Employer with prompt notice of such request.</p>
                <p><b>Article IX: Breach of agreement</b></p>
                <ol type="A">
                    <li><b> Cause for Action.</b>Employee understands that the use or disclosure of any Confidential Information 
                        may be cause for an action at law in an appropriate court of the Islamic Republic of Pakistan, or in any 
                        Employment Tribunal, and that the Employer shall be entitled to an injunction prohibiting the use or 
                        disclosure of the Confidential Information.
                        </li><br>
                        <li><b> Indemnification.</b>Employee understands and agrees that if the use or disclosure of Confidential 
                            Information by them or any affiliate, employee or representative of the Employee causes damage, loss, 
                            cost or expense to the Company, the Employee shall be held responsible and shall indemnify the 
                            Company. Employee will also be held liable for destroying company Property (laptops, mobile phones, 
                            etc.). Employee that is terminated\quit will return the company property in three working days else will 
                            face legal action, and will held liable for all legal expenses.</li><br>
                            <li><b> Injunctive Relief. </b> The Employee understands and agrees that the use or disclosure of Confidential 
                                Information could cause the Company irreparable harm and the Company has the right to pursue legal 
                                action beyond remedies of a monetary nature in the form of injunctive or equitable relief. This may be in 
                                addition to any other remedy, penalty or claim the law can provide.</li><br>
                                <li><b>Notice of Unauthorized Use or Disclosure.</b> Employee is bound by this Agreement to notify the 
                                    Company in the event of a breach of agreement involving the dissemination of Confidential Information, 
                                    either by the Employee or a third party, and will do everything possible to help the Company regain 
                                    possession of the Confidential Information,</li>
                </ol>
                <p><b>Article X: Prevailing party</b></p>
                <p>In a dispute arising out of or in relation to this Agreement, the prevailing party shall have the right to 
                    collect from the other party its reasonable attorney fees, costs, and necessary expenditures. IN 
                    WITNESS WHEREOF, the Parties hereto agree to the terms of this Agreement and signed on the dates 
                    written below.
                    </p>
                    <p style="padding-top: 20px;"><b>Employee Signature:</b>
                        <input type="text" class="text-line" />&nbsp;
                     Date: <input type="text" class="text-line" />
                    </p>
                    <p><b>Employee Printed Name:  </b>
                        <input type="text" class="text-line" />
                    </p>

</div>
        <div style="position: absolute; width: 100%; bottom: 50px; text-align: center">
            <span style="color: red; font-size: 10px">This document is company confidential and may not be distributed.</span> <br>
            <span style="font-size: 14px">Shell Software Enterprises</span>
        </div>


    
</body>';
        $this->pdf->loadHtml($html_content);
        $this->pdf->render();
        $output = $this->pdf->output();
        file_put_contents(APPPATH . 'modules/reports/assets/documents/nda/nda-letter-'.$file_name.'.pdf', $output);
        return 'nda-letter-'.$file_name.'.pdf';
    }
    public function add_contractual_agreement(){
        $firstName = $this->input->post('firstname',true);
        $lastName = $this->input->post('lastname',true);
        $emp_email = $this->input->post('user_email');
        $effective_date = $this->input->post('effective_date');
        $gender = $this->input->post('gender');
        $description_of_services = $this->input->post('description_of_services');
        $payment = $this->input->post('payment');
        $address = $this->input->post('address');
        $father_name = $this->input->post('father_name');
        $cnic = $this->input->post('cnic');
        $dob = $this->input->post('dob');

// Gender
        if($gender == 1){
            $gender = 'Mr';
        }elseif ($gender == 2){
            $gender = 'Miss';
        }

        $pdf_file_name = $this->add_pdf_contractual_agreement($firstName,$lastName,$gender,$effective_date,$description_of_services,$payment,$address,$father_name,$cnic,$dob);
        $pfd_file_path = base_url().'application/modules/reports/assets/documents/contractual_agreement/'.$pdf_file_name;

        $post_date= [
            'first_name' => $firstName,
            'last_name' => $lastName,
            'user_email' => $emp_email,
            'effective_date' => $effective_date,
            'father_name' => $father_name,
            'cnic' => $cnic,
            'dob' => $dob,
            'address' => $address,
            'offer_letter_path' => $pfd_file_path,
            'report_type' => '3'
        ];
        if($this->Onbording_model->crate_appointment_letter($post_date)){
            $this->email->set_mailtype("html");

            $msg = "<b><span style='font-size:12.0pt; font-family:&quot;Segoe UI&quot;,sans-serif; color:#201F1E'>Welcome to the team, $gender. $firstName $lastName!</span></b>             
            <br><br> Looking forward to having you in our family!
            <br><br><i><a href='mailto:Human.Resources@dynatuners.com' style='font-size:10.0pt; font-family:&quot;Arial&quot;,sans-serif; color:#1F497D'>Human.Resources@dynatuners.com</a></i>
            <br><i><a href='https://www.instructorbrandon.com/' style='font-size:10.0pt; font-family:&quot;Arial&quot;,sans-serif; color:#1F497D'>https://www.instructorbrandon.com/</a></i>
            <br><br><img src=".base_url()."application/modules/reports/assets/images/thumbnail_image001.png>";


            $this->email->attach($pfd_file_path);
            $this->email->set_newline("\r\n");
            $this->email->set_crlf("\r\n");
            $this->email->from(FROM_EMAIL); // change it to yours
            $this->email->to($emp_email); // change it to yours
//            $this->email->to('inam.ur.rehman@dynatuners.com');
            $this->email->CC('fey.ahmad@dynatuners.com');
            $this->email->subject("Contractual Agreement Dynatuners");
            $this->email->message($msg);
            $this->email->send();

            $this->session->set_flashdata('message', display('successfully_updated')); // sucess Message
        }else{
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("reports/Contractual_agreement_controller/contractual_agreement");
    }
    public function add_pdf_contractual_agreement($firstName,$lastName,$gender,$effective_date,$description_of_services,$payment,$address,$father_name,$cnic,$dob){
        $file_name = date('ymdst');
        $logo_get = file_get_contents(APPPATH."modules/reports/assets/images/MicrosoftTeams-image.png");
        $logo = base64_encode($logo_get);
        $bg_get = file_get_contents(APPPATH."modules/reports/assets/images/offer-letter-bg.png");
        $bg = base64_encode($bg_get);
        $effective_date = date('F d , Y', strtotime($effective_date));
        $dob = date('F d , Y', strtotime($dob));
        $html_content = '<style>
		@page {
			size: letter;
			margin: 0mm 0mm 0mm 0mm;
		}
		body {
			background-image: url(data:image;base64,'.$bg.');
			background-image-resize: 6;
			background-size: cover;
			padding: 60px 40px 20px 40px;
			font-size: 16px;
		}
        .main{
            margin-left: 20px;
            margin-top: 60px;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
            line-height: 16px;
        }
        .company{
            padding-top: 15px;
        }
        .hr{
           
            color: #0E78D9;
        }
        .web-link{
            color: #1866C7;
            
        }
        .list{
            color: #0F9196;
        }
        .position{
            padding-top: 20px;
        }
        .desc{
            padding-top: 20px;
        }
        .inner-list{
            list-style: none;
        }
        .last-text{
            padding-top: 15px;
        }
        .sse{
            padding-top: 40px;
        }
        .text-line {
			border-top: none;
			border-left: none;
			border-right: none;
			border-bottom: solid black 1px;
			padding: 4px 20px;
		}
        .header{
            margin: 0px 25px;
        }
        .first_para{
            margin: 0px 25px;
        }
        .logo-here{
            margin: 0px 25px;
        }
        .last_para{
            margin: 0px 25px;
        }
        .my_ol{
            margin: 0px 0px;
        }
        p{
            font-size: 13px;
        }
        li{
            font-size: 13px;
        }
        b{
            font-size: 14px;
        }
        
    </style>
<body>
    <div class="big-class">
    <div class="logo-here">
        <img src="data:image;base64,'.$logo.'" alt="" height="75" width="300">
    </div>
    <div class="main">
            
        <h2 class="header">Contractual Agreement</h2><br><br>
        <p class="first_para">
        This Contract for Services is made effective as of '.$effective_date.', by and between Shell Software Enterprises
        (Private) Ltd., of 31-D, Block-C, Gulberg III, Lahore, and '.$gender.'. '.$firstName.' '.$lastName.', of '.$address.'.
        </p><br>
            <ol class="my_ol">         
                <li>
                   <b> DESCRIPTION OF SERVICES.</b> <br> '.$description_of_services.'                
                </li>
                <li >
                   <b> PAYMENT.</b> <br> '.$payment.'                 
                </li>
                <li>
                   <b> TERM.</b> <br>This Contract will be automatically terminated after 30 days if not approved by the company. An email notice by one party will suffice.
                    <p> Shell Software Enterprises (Private) Ltd. reserves the right to terminate the Contract, in accordance with the law, where the deliverables aforementioned have not been achieved in the prescribed time. </p>             
                </li>
               <li>
                   <b> WORK PRODUCT OWNERSHIP.</b> Any copyrightable works, ideas, discoveries, inventions, patents, products, or other information (collectively the "Work Product") developed in whole or in part by '.$gender.'. '.$firstName.' '.$lastName.' in connection with the Services will be the exclusive property of Shell Software Enterprises (Private) Ltd. Upon request, '.$gender.'. '.$firstName.' '.$lastName.' will execute, within a reasonable period of time, all documents necessary to confirm or perfect the exclusive ownership of Shell Software Enterprises (Private) Ltd. to the Work Product.                    
                </li>
                <br>
                <li>
                    <b>CONFIDENTIALITY.</b> <br>'.$gender.'. '.$firstName.' '.$lastName.' will not at any time or in any manner, either directly or indirectly, use for the personal benefit of him/herself, or divulge, disclose, or communicate in any manner, any information that is proprietary to Shell Software Enterprises (Private) Ltd. '.$gender.'. '.$firstName.' '.$lastName.' and his employees, agents, and representatives will protect such information and treat it as strictly confidential. This provision will continue to be effective after the termination of this Contract. Any oral or written waiver by Shell Software Enterprises (Private) Ltd. of these confidentiality obligations which allow '.$gender.'. '.$firstName.' '.$lastName.' to disclose Shell Software Enterprises (Private) Ltd.s confidential information to a third party will be limited to a single occurrence tied to the specific information disclosed to the specific third party, and the confidentiality clause will continue to be in effect for all other occurrences.
                    <br>
                    Upon termination of this Contract, '.$gender.'. '.$firstName.' '.$lastName.' will return to Shell Software Enterprises (Private) Ltd. all records, notes, documentation and other items that were used, created, or controlled by the Service Provider during the term of this Contract.
                </li>
                <br>
                <li>
                    <b>INDEMNIFICATION.</b> <br>'.$gender.'. '.$firstName.' '.$lastName.' agrees to indemnify and hold Shell Software Enterprises (Private) Ltd. harmless from all claims, losses, expenses, fees including attorney fees, costs, and judgments that may be asserted against Shell Software Enterprises (Private) Ltd. that result from the acts or omissions of '.$gender.'. '.$firstName.' '.$lastName.' and/or '.$gender.'. '.$firstName.' '.$lastName.' and his employees, agents, or representatives.
                </li>
                <br>
                <li>
                    <b>WARRANTY.</b> <br> '.$gender.'. '.$firstName.' '.$lastName.' shall provide his services and meet his obligations under this Contract in a timely and professional manner, using knowledge and recommendations for performing the services which meet generally acceptable standards in '.$gender.'. '.$firstName.' '.$lastName.'s service sector, and will provide a standard of care equal to, or superior to, care used by professional service providers operating in the same industry.
                </li>
                <br>
                <li >
                    <b>DEFAULT.</b> <br> The occurrence of any of the following shall constitute a material default under this Contract:
                    <br><br>a) The failure to make a required payment when due.
                    <br><br>b) The insolvency or bankruptcy of either party.
                    <br><br>c) The subjection of any of either partys property to any levy, seizure, general assignment for the benefit of creditors, application or sale for or by any creditor or government agency.
                    <br><br>d) The failure to make available, or deliver the Services in the time and manner provided for in this Contract.
                </li>
                <br>
                <li>
                    <b>INDEPENDENT CONTRACTOR.</b> <br> Each party shall be, and act as an independent contractor and not as partner, joint venture, employee, representative or agent of the other and shall not bind nor attempt to bind the other to any contract.
                    <p>'.$gender.'. '.$firstName.' '.$lastName.' is an independent contractor and is solely responsible for all taxes, withholdings, labor obligations with his employees and other statutory or contractual obligations of any sort, including, but not limited to, workers’ compensation insurance.</p>
                    <p>'.$gender.'. '.$firstName.' '.$lastName.' agrees to defend, indemnify, and hold harmless Shell Software Enterprises (Private) Ltd. from all claims, damages, liability, attorneys’ fees and expenses.</p>
                    <p>'.$gender.'. '.$firstName.' '.$lastName.' will ensure that his employees and agents are bound to his obligations under this Agreement, with focus to service law of the Islamic Republic of Pakistan. '.$gender.'. '.$firstName.' '.$lastName.' remains directly responsible for compliance with this Agreement and its clauses.</p>
                </li>
                <li>
                    <b>ASSIGNMENT.</b> <br> This Agreement and the services contemplated here under are personal to '.$gender.'. '.$firstName.' '.$lastName.', and he shall not have the right or ability to assign, transfer, or subcontract any obligation under this Agreement without the prior written consent of Shell Software Enterprises (Private) Ltd. Any attempt to do so, shall be null and void, which will result in recovering expectation damages and consequential damages by Shell Software Enterprises (Private) Ltd.
                </li>
                <br>
                <li>
                    <b>REMEDIES.</b> <br> In addition to any and all other rights a party may have available according to law, if a party defaults by failing to substantially perform any provision, term or condition of this Contract (including without limitation the failure to make a monetary payment when due), the other party may terminate the Contract by providing written notice to the defaulting party. This notice shall describe with sufficient detail the nature of the default. The party receiving such notice shall have 3 days from the effective date of such notice to cure the default(s). Unless waived in writing by a party providing notice, the failure to cure the default(s) within such time period shall result in the automatic termination of this Contract.
                    <p>Upon breach of any of the terms, provisions, or conditions held under this Contract, both parties may seek remedy
                    through payment of damages, and in cases of misrepresentation, mutual mistake, or frustration of Contract, seek
                    the recission of Contract. In instances where there is part performance of the Contract by either party, the remedy
                    of quantum meruit may be availed at Court.</p>
                    <p><b>SHELL SOFTWARE ENTERPRISES (PRIVATE) LTD.S RESPONSIBILITY AND LIABILITY</b></p>
                    <p>Shell Software Enterprises (Private) Ltd. is not responsible for any damage, loss or injury caused or suffered by '.$gender.'. '.$firstName.' '.$lastName.' in compliance with his obligations. It is not responsible for the unlawful actions carried out by '.$gender.'. '.$firstName.' '.$lastName.' or his employees and/or his agents. Shell Software Enterprises (Private) Ltd. is not responsible for the obligations which '.$gender.'. '.$firstName.' '.$lastName.' has towards his employees.</p>
                    <p>In addition to any other right or remedy provided by law, if Shell Software Enterprises (Private) Ltd. fails to pay for the Services when due, '.$gender.'. '.$firstName.' '.$lastName.' has the option to treat such failure to pay as a material breach of this Contract, and may cancel this Contract and/or seek legal remedies, which include only his payment, and reasonable attorney fees. </p>
                    <p > '.$gender.'. '.$firstName.' '.$lastName.' will defend, indemnify and hold harmless (including, reasonable attorneys’ fees and costs) Shell Software Enterprises (Private) Ltd., its officers, directors and employees from and against any actual or threatened claims, suits, or proceedings arising out of, relating to, or based upon: (i) any breach by '.$gender.'. '.$firstName.' '.$lastName.' of his obligations, warranties and representations set forth in this Agreement or any SOW; and, (ii) any breach of the provisions respecting Shell Software Enterprises (Private) Ltd.s proprietary information. Shell Software Enterprises (Private) Ltd. will not be liable for any vicarious liability for any of '.$gender.'. '.$firstName.' '.$lastName.'s employees.</p>
                    <p>The property rights/copyrights over concepts, layouts, images and figures, logotypes, know-how, research studies, artistic, scientific creations, texts, expressions, methodologies, audiovisual works, translations, illustrations, drawings, photographs, processes, products, formulas, methods and improvements, or part of these, and even computer programs, algorithms, subroutines, source codes, object codes, designs, any derivations, improvements and refinements, or reduced to a tangible form put in practice or not, among any other result arising from the performance of services by '.$gender.'. '.$firstName.' '.$lastName.' (hereinafter simply referred to as "Works") are the sole property of Shell Software Enterprises (Private) Ltd., for all legal purposes, created by Shell Software Enterprises (Private) Ltd. s order.</p>
                    <p>Being the owner of such intellectual property rights/copyrights, Shell Software Enterprises (Private) Ltd. may use and exploit such Works, in Pakistan and abroad, irrevocably and exclusively, granting Shell Software Enterprises (Private) Ltd.s right to modify, translate into any language, edit, publish, display, reproduce, adapt, distribute, practice, transmit and/or disclose, license and/or transfer to third parties such Works and/or such rights, including them as part of derivative works and/or collective, organized by third parties or by Shell Software Enterprises (Private) Ltd., at any time.</p>
                </li>
                <li>
                    <b>FORCE MAJEURE.</b> <br> If performance of this Contract or any obligation under this Contract is prevented, restricted, or interfered with by causes beyond either partys reasonable control ("Force Majeure"), and if the party unable to carry out its obligations gives the other party prompt written notice of such event, then the obligations of the party invoking this provision shall be suspended to the extent necessary by such event. The term Force Majeure shall include, without limitation, acts of God, fire, explosion, vandalism, storm or other similar occurrence, orders or acts of military or civil authority, or by national emergencies, insurrections, riots, or wars, or strikes, lock-outs, work stoppages, or supplier failures. The excused party shall use reasonable efforts under the circumstances to avoid or remove such causes of non-performance and shall proceed to perform with reasonable dispatch whenever such causes are removed or ceased. An act or omission shall be deemed within the reasonable control of a party if committed, omitted, or caused by such party, or its employees, officers, agents, or affiliates.
                </li>
                <br>
                <li>
                    <b>DISPUTE RESOLUTION.</b><br>The parties will attempt to resolve any dispute out of or relating to this Agreement through friendly negotiations amongst the parties. If the matter is not resolved by negotiation, the parties will resolve the dispute using the below Alternative Dispute Resolution (ADR) procedure.
                    <p>Any controversies or disputes arising out of or relating to this Agreement will be submitted to mediation in accordance with any statutory rules of mediation. If mediation is not successful in resolving the entire dispute or is unavailable, any outstanding issues will be submitted to final and binding arbitration. The arbitrators award will be final, and judgment may be entered upon it by any court having proper jurisdiction.</p>
                </li> <br>
                <li> 
                    <b>ENTIRE AGREEMENT.</b> This Contract contains the entire agreement of the parties, and there are no other promises or conditions in any other agreement whether oral or written concerning the subject matter of this Contract. This Contract supersedes any prior written or oral agreements between the parties.
                </li> <br><br>
                <li> 
                    <b>SEVERABILITY.</b> If any provision of this Contract will be held to be invalid or unenforceable for any reason, the remaining provisions will continue to be valid and enforceable. If a court finds that any provision of this Contract is invalid or unenforceable, but that by limiting such provision it would become valid and enforceable, then such provision will be deemed to be written, construed, and enforced as so limited.
                </li> <br> <br>
                <li > 
                    <b>AMENDMENT.</b> This Contract may be modified or amended in writing by mutual agreement between the parties, if the writing is signed by the party obligated under the amendment.
                </li>
                <br>
                <li> 
                    <b>GOVERNING LAW.</b> This Contract shall be construed in accordance with the laws of the Islamic Republic of Pakistan.
                </li><br><br>        
                <li> 
                    <b>NOTICE</b>. Any notice or communication required or permitted under this Contract shall be sufficiently given if delivered in person or by certified mail, return receipt requested, to the address set forth in the opening paragraph or to such other address as one party may have furnished to the other in writing.
                </li> <br>
                <li> 
                    <b>WAIVER OF CONTRACTUAL RIGHT.</b><br>The failure of either party to enforce any provision of this Contract shall not be construed as a waiver or limitation of that partys right to subsequently enforce and compel strict compliance with every provision of this Contract.
                </li> <br>
                <li>
                    <b>ATTORNEYS FEES TO PREVAILING PARTY.</b> In any action arising hereunder or any separate action pertaining to the validity of this Agreement, the prevailing party shall be awarded reasonable attorneys fees and costs, both in the trial court and on appeal.
                </li> <br>
                <li> 
                    <b>CONSTRUCTION AND INTERPRETATION.</b> 
                    <p>The rule requiring construction or interpretation against the drafter is waived. The document shall be deemed as if it were drafted by both parties in a mutual effort.</p>
                    <p>IN WITNESS WHEREOF, the parties hereto have caused this Agreement to be executed by their duly authorized representatives as of the date first above written. Representative, Shell Software Enterprises (Private) Ltd., and '.$gender.'. '.$firstName.' '.$lastName.', Service Provider, effective as of the date first above written.</p>
                    Service Recipient:<br>
                    Shell Software Enterprises (Private) Ltd. <br>
                </li>
            </ol>
            <p class="last_para">
            <br><br><br>
            By: ________________________________________

            <br><br>Representative Name

            <br><br><br><br><br><br>
            By: ________________________________________
            <br><br>
            Service Provider:
            <br>'.$gender.'. '.$firstName.' '.$lastName.'
            <br><br> 
            <b>Mention ID card details:</b>
            <br>Father Name: '.$father_name.'
            <br>Identity Number: '.$cnic.'
            <br>Date of Birth: '.$dob.'
            </p>
    </div>
</div>
    
</body>';
        $this->pdf->loadHtml($html_content);
        $this->pdf->render();
        $output = $this->pdf->output();
        file_put_contents(APPPATH.'modules/reports/assets/documents/contractual_agreement/contractual-agreement-'.$file_name.'.pdf', $output);
        return 'contractual-agreement-'.$file_name.'.pdf';
    }
}