<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Resignation_controller extends MX_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Resignation_model'
        ));

        if (!$this->session->userdata('isLogIn'))
            redirect('login');
    }

    public function create_resignation(){
        $data['title'] = "Resignation";

        $data['message'] = (object)$postData = array(
            'res_message'     => $this->input->post('res_message', true),
            'res_attachment'     => $this->input->post('res_attachment', true),
            'supervisor_id'     => $this->input->post('supervisor_id', true),
        );

        /*-----------CREATE A NEW RECORD-----------*/
        if ($this->form_validation->run() === true) {
            if ($this->message_model->create_resignation($postData)) {
                #set success message
                $this->session->set_flashdata('message', "Your resignation has been sent to your supervisor");
            } else {
                #set exception message
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('resignation/Resignation_controller/create_resignation');
        } else {
            $email = $this->session->userdata('email');
            $data['supervisor_id'] = $this->Resignation_model->get_supervisor($email);
            $data['module'] = "resignation";
            $data['page']   = "create_resignation";
            echo Modules::run('template/layout', $data);
        }
    }

}