<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Skills_controller extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Skills_model',
        ));
    }

    public function skills_view()
    {
        $this->permission->method('skills','read')->redirect();
        $data['title']    = display('skills');  ;
        $data['mang']     = $this->Skills_model->skills_view();
        $data['module']   = "skills";
        $data['page']     = "skills_view";
        echo Modules::run('template/layout', $data);
    }

    public function create_skills()
    {
        $data['title'] = display('skills');
        #-------------------------------#
        $this->form_validation->set_rules('skill_name', 'Skill', 'required|max_length[150]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
                'skill_name' => $this->input->post('skill_name', true),
            ];

            if ($this->Skills_model->skills_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("skills/Skills_controller/create_skills");

        } else {
            $data['title'] = display('skills');
            $data['module'] = "skills";
            $data['mang']     = $this->Skills_model->skills_view();
            $data['page'] = "skills_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function update_skills_form($id = null)
    {
        $this->form_validation->set_rules('skill_id',display('skill_id'));
        $this->form_validation->set_rules('skill_name',display('skill_name'),'required|max_length[150]');

        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $Data = [
                'skill_id'         =>   $this->input->post('skill_id',true),
                'skill_name' => $this->input->post('skill_name',true),

            ];

            if ($this->Skills_model->update_skills($Data)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("skills/Skills_controller/skills_view");



        } else {
            $data['title']      = display('update');
            $data['data']      = $this->Skills_model->skills_updateForm($id);
            $data['module']    = "skills";
            $data['page']      = "update_skills_form";
            echo Modules::run('template/layout', $data);
        }
    }

    public function delete_skills($id=null){
        $this->permission->module('skills','delete')->redirect();
        if($this->Skills_model->skills_delete($id)) {
            #set success message
            $this->session->set_flashdata('message',display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception',display('please_try_again'));
        }
        redirect('skills/Skills_controller/skills_view');
    }

}
