<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Training_model extends CI_Model {
 
    public function training_view()
	{
        return $this->db->select('count(DISTINCT(tr.training_id)) as training_id,tr.*,p.employee_id,p.first_name,p.last_name')
            ->from('training tr')
            ->join('employee_history p', 'tr.employee_id = p.employee_id', 'left')
            ->group_by('tr.training_id')
            ->order_by('tr.training_id', 'desc')
            ->get()
            ->result();
	}
    public function dropdown(){
        $this->db->select('*');
        $this->db->from('employee_history');
        $this->db->where('employee_status',1);
        $query=$this->db->get();
        $data=$query->result();
        $list = array('' => 'Select One...');
        if(!empty($data)){
            foreach ($data as  $value) {
                $list[$value->employee_id]=$value->first_name." ".$value->last_name;
            }
        }
        return $list;
    }

    public function training_create($data = array())
    {
        return $this->db->insert('training', $data);
    }

    public function update_training($data = array())
    {
        return $this->db->where('training_id',$data["training_id"])
            ->update("training", $data);
    }
    public function training_updateForm($id){
        $this->db->where('training_id',$id);
        $query = $this->db->get('training');
        return $query->row();
    }
    public  function get_id($id)
    {
        $query=$this->db->get_where('training',array('training_id'=>$id));
        return $query->row_array();
    }

    public function training_delete($id = null)
    {
        $this->db->where('training_id',$id)
            ->delete('training');

        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }

}
